/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc3000;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.tests.reqif10.serialization.model.toolextension.Extension;
import org.eclipse.rmf.tests.reqif10.serialization.model.toolextension.SpecObjectExtension;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc3000.TC3000ToolExtensionsModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC3000ToolExtensionsTests
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC3000";
    static final String REFERENCE_DATA_FILENAME = TC3000ToolExtensionsTests.getWorkingFileName(TC3000ToolExtensionsTests.getReferenceDataFileName("TC3000", false));
    static final String EXPORT_DATA_FILENAME = TC3000ToolExtensionsTests.getWorkingFileName(TC3000ToolExtensionsTests.getFirstExportFileName("TC3000", false));
    static ReqIF originalReqIF = null;
    static ReqIF loadedReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalReqIF = new TC3000ToolExtensionsModelBuilder().getReqIF();
        TC3000ToolExtensionsTests.saveReqIFFile((EObject)originalReqIF, REFERENCE_DATA_FILENAME);
        loadedReqIF = TC3000ToolExtensionsTests.loadReqIFFile(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testReqIFNotNull() {
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedReqIF);
    }

    @Test
    public void testNoProxies() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedReqIF);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedReqIF);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testResave() throws IOException {
        try {
            TC3000ToolExtensionsTests.saveReqIFFile(EcoreUtil.copy((EObject)loadedReqIF), EXPORT_DATA_FILENAME);
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }

    @Test
    public void testNoXMLAnyType() {
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)loadedReqIF, (boolean)true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Assert.assertFalse((boolean)(eObject instanceof AnyType));
        }
    }

    @Test
    public void testExtension() {
        Assert.assertSame((Object)1, (Object)loadedReqIF.getToolExtensions().size());
        ReqIFToolExtension reqIFToolExtension = (ReqIFToolExtension)loadedReqIF.getToolExtensions().get(0);
        Assert.assertSame((Object)1, (Object)reqIFToolExtension.getExtensions().size());
        Assert.assertTrue((boolean)(reqIFToolExtension.getExtensions().get(0) instanceof Extension));
        Extension extension = (Extension)reqIFToolExtension.getExtensions().get(0);
        Assert.assertSame((Object)2, (Object)extension.getSpecObjectExtensions().size());
        SpecObjectExtension specObjectExtension1 = (SpecObjectExtension)extension.getSpecObjectExtensions().get(0);
        SpecObjectExtension specObjectExtension2 = (SpecObjectExtension)extension.getSpecObjectExtensions().get(1);
        SpecObject specObject = (SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0);
        Assert.assertEquals((Object)"This is an extended description of a SpecObject", (Object)specObjectExtension1.getExtendedDesc());
        Assert.assertSame((Object)specObject, (Object)specObjectExtension1.getExtendedSpecObject());
        Assert.assertEquals((Object)"This is another extended description of a SpecObject", (Object)specObjectExtension2.getExtendedDesc());
        Assert.assertSame((Object)specObject, (Object)specObjectExtension2.getExtendedSpecObject());
    }
}

