/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.editors.PopupCellEditor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProrDateCellEditor
extends PopupCellEditor {
    private DateTime date;
    private DateTime time;
    private AttributeValueDate attributeValue;
    private EditingDomain editingDomain;
    private Object affectedObject;
    private Object parent;

    public ProrDateCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, Object parent, Object affectedObject) {
        super(agileGrid);
        this.editingDomain = editingDomain;
        this.affectedObject = affectedObject;
        this.parent = parent;
    }

    protected Object doGetValue() {
        GregorianCalendar value = new GregorianCalendar(this.date.getYear(), this.date.getMonth(), this.date.getDay(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds());
        ProrUtil.setTheValue((AttributeValue)this.attributeValue, (Object)value, (Object)this.parent, (Object)this.affectedObject, (EditingDomain)this.editingDomain);
        return this.attributeValue;
    }

    protected void doSetValue(Object value) {
        if (value instanceof AttributeValueDate) {
            this.attributeValue = (AttributeValueDate)value;
        }
        super.doSetValue(value);
    }

    protected void updateLabel(Object value) {
        AttributeValueDate av;
        if (value instanceof AttributeValueDate && (av = (AttributeValueDate)value).getTheValue() != null) {
            Date date = av.getTheValue().getTime();
            super.updateLabel((Object)DateFormat.getDateTimeInstance().format(date));
            return;
        }
        super.updateLabel(value);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.date = new DateTime(composite, 66560);
        this.time = new DateTime(composite, 128);
        GridData gd = new GridData(4, 4, true, false);
        this.time.setLayoutData((Object)gd);
        Object cal = ReqIF10Util.getTheValue((AttributeValue)this.attributeValue);
        if (cal instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)cal;
            this.date.setDate(calendar.get(1), calendar.get(5), 5);
            this.time.setTime(calendar.get(10), calendar.get(12), 13);
        }
        return composite;
    }

    protected void openPopupBox(Control parent) {
        super.openPopupBox(parent);
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        shell.pack();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

