/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.List;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.search.filter.BoolFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControl;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class FilterControlBoolean
extends FilterControl {
    private Combo valueControl;

    public FilterControlBoolean(FilterPanel parent, AttributeDefinitionBoolean attribute) {
        super(parent, (AttributeDefinition)attribute);
    }

    public FilterControlBoolean(FilterPanel parent, BoolFilter template) {
        super(parent, (IFilter)template);
    }

    @Override
    protected void updateValueControls(boolean initialize) {
        if (this.getOperator() == IFilter.Operator.IS_SET || this.getOperator() == IFilter.Operator.IS_NOT_SET) {
            this.showValueControl(false);
        } else {
            this.showValueControl(true);
            if (initialize) {
                Boolean defaultValue = (Boolean)this.templateFilter.getFilterValue1();
                this.valueControl.select(Boolean.TRUE.equals(defaultValue) ? 1 : 0);
            }
        }
        this.layout();
    }

    private void showValueControl(boolean show) {
        if (show && this.valueControl == null) {
            this.valueControl = new Combo((Composite)this, 2060);
            this.valueControl.add("FALSE");
            this.valueControl.add("TRUE");
            this.valueControl.select(0);
            GridData layoutData = new GridData(4, 0x1000000, true, false);
            this.valueControl.setLayoutData((Object)layoutData);
        } else if (!show && this.valueControl != null) {
            this.valueControl.dispose();
            this.valueControl = null;
        }
    }

    @Override
    public IFilter getFilter() {
        Boolean value = this.valueControl == null ? null : new Boolean(this.valueControl.getSelectionIndex() == 1);
        return new BoolFilter(this.getOperator(), value, (AttributeDefinitionBoolean)this.attribute);
    }

    @Override
    protected List<IFilter.Operator> getOperators() {
        return BoolFilter.SUPPORTED_OPERATORS.asList();
    }
}

