/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public abstract class AbstractAttributeFilter
implements IFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.IS_SET, (Enum[])new IFilter.Operator[]{IFilter.Operator.IS_NOT_SET});

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.getAttribute() instanceof AttributeDefinition) {
            switch (this.getOperator()) {
                case IS_SET: {
                    return AbstractAttributeFilter.isSetAttribute(element, (AttributeDefinition)this.getAttribute()) && this.hasNonNullValue(element);
                }
                case IS_NOT_SET: {
                    return AbstractAttributeFilter.isSetAttribute(element, (AttributeDefinition)this.getAttribute()) && !this.hasNonNullValue(element);
                }
            }
            throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.getOperator()) + " operation");
        }
        Object attributeValue = this.getInternalAttributeValue(element);
        switch (this.getOperator()) {
            case IS_SET: {
                return attributeValue != null;
            }
            case IS_NOT_SET: {
                return attributeValue == null;
            }
        }
        throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.getOperator()) + " operation");
    }

    public static boolean isSetAttribute(SpecElementWithAttributes element, AttributeDefinition attributeDefinition) {
        SpecType specType = ReqIF10Util.getSpecType((SpecElementWithAttributes)element);
        if (specType == null) {
            return false;
        }
        return specType.getSpecAttributes().contains((Object)attributeDefinition);
    }

    private boolean hasNonNullValue(SpecElementWithAttributes element) {
        AttributeValue attributeValue = ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)((AttributeDefinition)this.getAttribute()));
        if (attributeValue == null) {
            return false;
        }
        Object theValue = ReqIF10Util.getTheValue((AttributeValue)attributeValue);
        return theValue != null;
    }

    protected Object getInternalAttributeValue(SpecElementWithAttributes element) {
        return null;
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String attribute = null;
        if (this.getAttribute() instanceof AttributeDefinition) {
            AttributeDefinition ad = (AttributeDefinition)this.getAttribute();
            attribute = ad.getLongName();
            if (attribute == null) {
                attribute = ad.getDesc();
            }
            if (attribute == null) {
                attribute = "Attribute with ID=" + ad.getIdentifier();
            }
        } else {
            attribute = this.getAttribute().toString();
        }
        sb.append(attribute);
        sb.append(" ");
        sb.append(this.getOperator().toLocaleString());
        if (this.getOperator() == IFilter.Operator.IS_SET || this.getOperator() == IFilter.Operator.IS_NOT_SET) {
            return sb.toString();
        }
        sb.append(" ");
        sb.append(this.getFilterValue1AsString());
        if (this.getOperator().equals((Object)IFilter.Operator.BETWEEN)) {
            sb.append(" and ").append(this.getFilterValue2AsString());
        }
        return sb.toString();
    }

    public String getFilterValue1AsString() {
        return this.getFilterValue1().toString();
    }

    public String getFilterValue2AsString() {
        return this.getFilterValue2().toString();
    }
}

