/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class SimpleCompoundFilter
implements IFilter {
    private boolean orFilter;
    private final List<IFilter> filters;

    public SimpleCompoundFilter(List<IFilter> filters, boolean orFilter) {
        this.orFilter = orFilter;
        this.filters = new LinkedList<IFilter>(filters);
    }

    public boolean isOrFilter() {
        return this.orFilter;
    }

    public List<IFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        for (IFilter filter : this.filters) {
            boolean match = filter.match(element);
            if (this.orFilter) {
                if (!match) continue;
                return true;
            }
            if (match) continue;
            return false;
        }
        return !this.orFilter;
    }

    @Override
    public Object getAttribute() {
        return null;
    }

    @Override
    public IFilter.Operator getOperator() {
        return null;
    }

    @Override
    public Object getFilterValue1() {
        return null;
    }

    @Override
    public Object getFilterValue2() {
        return null;
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String op = this.orFilter ? " OR " : " AND ";
        Iterator<IFilter> iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            IFilter filter = iterator.next();
            sb.append(filter.toString());
            if (!iterator.hasNext()) continue;
            sb.append(String.valueOf(op) + System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

