/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.AbstractTextFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class XhtmlFilter
extends AbstractTextFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.CONTAINS, (Enum[])new IFilter.Operator[]{IFilter.Operator.NOT_CONTAINS, IFilter.Operator.REGEXP, IFilter.Operator.REGEXP_PLAIN, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});

    public XhtmlFilter(IFilter.Operator operator, String value, AttributeDefinitionXHTML attributeDefinition, boolean caseSensitive) {
        super(operator, value, (AttributeDefinition)attributeDefinition, caseSensitive);
    }

    private XhtmlFilter(IFilter.Operator operator, String value, AbstractTextFilter.InternalAttribute internalFeature, boolean caseSensitive) {
        super(operator, value, internalFeature, null, caseSensitive);
        throw new InstantiationError("The XhtmlFilter does not support internalFeature.");
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.operator.equals((Object)IFilter.Operator.REGEXP_PLAIN)) {
            AttributeValueXHTML attributeValue = (AttributeValueXHTML)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
            XhtmlContent theValue = null;
            if (attributeValue != null) {
                theValue = attributeValue.getTheValue();
            }
            if (theValue == null) {
                theValue = this.getDefaultXhtmlContent(element);
            }
            String simplifiedString = theValue == null ? "" : ProrXhtmlSimplifiedHelper.xhtmlToSimplifiedString((XhtmlContent)theValue);
            return this.matchRegexp(simplifiedString);
        }
        return super.match(element);
    }

    @Override
    protected String getInternalAttributeValue(SpecElementWithAttributes element) {
        return null;
    }

    @Override
    protected String getAttributeValue(SpecElementWithAttributes element) {
        AttributeValueXHTML attributeValue = (AttributeValueXHTML)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
        if (attributeValue == null) {
            return null;
        }
        XhtmlContent xhtmlContent = attributeValue.getTheValue();
        try {
            return ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)xhtmlContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    @Override
    protected String getDefaultValue(SpecElementWithAttributes element) {
        if (!AbstractAttributeFilter.isSetAttribute(element, this.attributeDefinition)) {
            return null;
        }
        try {
            XhtmlContent xhtmlContent = this.getDefaultXhtmlContent(element);
            return xhtmlContent == null ? null : ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)xhtmlContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private XhtmlContent getDefaultXhtmlContent(SpecElementWithAttributes element) {
        if (!AbstractAttributeFilter.isSetAttribute(element, this.attributeDefinition)) {
            return null;
        }
        if (this.attributeDefinition instanceof AttributeDefinitionXHTML) {
            AttributeDefinitionXHTML ad = (AttributeDefinitionXHTML)this.attributeDefinition;
            return ad.isSetDefaultValue() ? ad.getDefaultValue().getTheValue() : null;
        }
        throw new IllegalStateException("Expected an AttributeDefinitionString as attribute but found " + this.attributeDefinition.getClass());
    }
}

