/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.RelationGroup;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;

public class ReqIFUtil {
    public static ReqIF getReqIF(EObject eObject) {
        EObject root = EcoreUtil.getRootContainer((EObject)eObject);
        if (root != null && root instanceof ReqIF) {
            return (ReqIF)root;
        }
        return null;
    }

    public static SpecType getSpecType(SpecElementWithAttributes specElementWithAttributes) {
        SpecObjectType specType = null;
        if (specElementWithAttributes != null) {
            switch (specElementWithAttributes.eClass().getClassifierID()) {
                case 12: {
                    specType = ((SpecObject)specElementWithAttributes).getType();
                    break;
                }
                case 14: {
                    specType = ((Specification)specElementWithAttributes).getType();
                    break;
                }
                case 20: {
                    specType = ((RelationGroup)specElementWithAttributes).getType();
                    break;
                }
                case 18: {
                    specType = ((SpecRelation)specElementWithAttributes).getType();
                    break;
                }
                default: {
                    specType = null;
                }
            }
        }
        return specType;
    }

    public static AttributeDefinition getAttributeDefinition(AttributeValue attributeValue) {
        AttributeDefinitionBoolean attributeDefinition = null;
        if (attributeValue != null) {
            switch (attributeValue.eClass().getClassifierID()) {
                case 28: {
                    attributeDefinition = ((AttributeValueBoolean)attributeValue).getDefinition();
                    break;
                }
                case 32: {
                    attributeDefinition = ((AttributeValueDate)attributeValue).getDefinition();
                    break;
                }
                case 37: {
                    attributeDefinition = ((AttributeValueEnumeration)attributeValue).getDefinition();
                    break;
                }
                case 40: {
                    attributeDefinition = ((AttributeValueInteger)attributeValue).getDefinition();
                    break;
                }
                case 43: {
                    attributeDefinition = ((AttributeValueReal)attributeValue).getDefinition();
                    break;
                }
                case 46: {
                    attributeDefinition = ((AttributeValueString)attributeValue).getDefinition();
                    break;
                }
                case 2: {
                    attributeDefinition = ((AttributeValueXHTML)attributeValue).getDefinition();
                    break;
                }
                default: {
                    attributeDefinition = null;
                }
            }
        }
        return attributeDefinition;
    }

    public static AttributeValue getAttributeValueForLabel(SpecElementWithAttributes specElementWithAttributes, String longName) {
        SpecType specType;
        AttributeValue attributeValue = null;
        if (specElementWithAttributes != null && longName != null && (specType = ReqIFUtil.getSpecType(specElementWithAttributes)) != null) {
            AttributeDefinition attributeDefinition = null;
            int size = specType.getSpecAttributes().size();
            int i = 0;
            while (i < size) {
                AttributeDefinition possibleAttributeDefinition = (AttributeDefinition)specType.getSpecAttributes().get(i);
                if (longName.equals(possibleAttributeDefinition.getLongName())) {
                    attributeDefinition = possibleAttributeDefinition;
                    break;
                }
                ++i;
            }
            if (attributeDefinition != null) {
                size = specElementWithAttributes.getValues().size();
                int i2 = 0;
                while (i2 < size) {
                    AttributeValue possibleAttributeValue = (AttributeValue)specElementWithAttributes.getValues().get(i2);
                    if (attributeDefinition == ReqIFUtil.getAttributeDefinition(possibleAttributeValue)) {
                        attributeValue = possibleAttributeValue;
                        break;
                    }
                    ++i2;
                }
            }
        }
        return attributeValue;
    }

    public static Object getTheValue(AttributeValue attributeValue) {
        switch (attributeValue.eClass().getClassifierID()) {
            case 28: {
                return ((AttributeValueBoolean)attributeValue).isTheValue();
            }
            case 32: {
                return ((AttributeValueDate)attributeValue).getTheValue();
            }
            case 37: {
                return ((AttributeValueEnumeration)attributeValue).getValues();
            }
            case 40: {
                return ((AttributeValueInteger)attributeValue).getTheValue();
            }
            case 43: {
                return ((AttributeValueReal)attributeValue).getTheValue();
            }
            case 46: {
                return ((AttributeValueString)attributeValue).getTheValue();
            }
            case 2: {
                return ((AttributeValueXHTML)attributeValue).getTheValue();
            }
        }
        return null;
    }
}

