/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.Serializable;
import org.eclipse.ecf.core.identity.ID;

public class ContainerMessage
implements Serializable {
    private static final long serialVersionUID = 3257009847533975857L;
    private ID fromContainerID;
    private ID toContainerID;
    private long sequence;
    private Serializable data;

    public Serializable getData() {
        return this.data;
    }

    public void setData(Serializable data) {
        this.data = data;
    }

    public ID getFromContainerID() {
        return this.fromContainerID;
    }

    public void setFromContainerID(ID fromContainerID) {
        this.fromContainerID = fromContainerID;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public ID getToContainerID() {
        return this.toContainerID;
    }

    public void setToContainerID(ID toContainerID) {
        this.toContainerID = toContainerID;
    }

    public static ContainerMessage createViewChangeMessage(ID from, ID to, long seq, ID[] ids, boolean add, Serializable data) {
        return new ContainerMessage(from, to, seq, new ViewChangeMessage(ids, add, data));
    }

    public static ContainerMessage createJoinGroupMessage(ID from, ID to, long seq, Serializable data) {
        return new ContainerMessage(from, to, seq, new JoinGroupMessage(data));
    }

    public static ContainerMessage createLeaveGroupMessage(ID from, ID to, long seq, Serializable data) {
        return new ContainerMessage(from, to, seq, new LeaveGroupMessage(data));
    }

    public static ContainerMessage createSharedObjectCreateMessage(ID from, ID to, long seq, Serializable data) {
        return new ContainerMessage(from, to, seq, new CreateMessage(data));
    }

    public static ContainerMessage createSharedObjectCreateResponseMessage(ID from, ID to, long contSeq, ID soID, Throwable e, long sequence) {
        return new ContainerMessage(from, to, contSeq, new CreateResponseMessage(soID, e, sequence));
    }

    public static ContainerMessage createSharedObjectMessage(ID from, ID to, long seq, ID fromSharedObject, Serializable data) {
        return new ContainerMessage(from, to, seq, new SharedObjectMessage(fromSharedObject, data));
    }

    public static ContainerMessage createSharedObjectDisposeMessage(ID from, ID to, long seq, ID sharedObjectID) {
        return new ContainerMessage(from, to, seq, new SharedObjectDisposeMessage(sharedObjectID));
    }

    protected ContainerMessage(ID from, ID to, long seq, Serializable data) {
        this.fromContainerID = from;
        this.toContainerID = to;
        this.sequence = seq;
        this.data = data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ContainerMessage[");
        sb.append(this.fromContainerID).append(";").append(this.toContainerID).append(";");
        sb.append(this.sequence).append(";").append(this.data).append("]");
        return sb.toString();
    }

    public static final class CreateMessage
    implements Serializable {
        private static final long serialVersionUID = 3257849874417595703L;
        Serializable data;

        CreateMessage(Serializable data) {
            this.data = data;
        }

        public Serializable getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("CreateMessage[");
            sb.append(this.data).append("]");
            return sb.toString();
        }
    }

    public static final class CreateResponseMessage
    implements Serializable {
        private static final long serialVersionUID = 3762531213570554166L;
        private final ID sharedObjectID;
        private final Throwable exception;
        private final long sequence;

        public CreateResponseMessage(ID objID, Throwable except, long sequence) {
            this.sharedObjectID = objID;
            this.exception = except;
            this.sequence = sequence;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("CreateResponseMessage[");
            sb.append(this.sharedObjectID).append(";").append(this.exception).append(";").append(this.sequence).append("]");
            return sb.toString();
        }

        public Throwable getException() {
            return this.exception;
        }

        public long getSequence() {
            return this.sequence;
        }

        public ID getSharedObjectID() {
            return this.sharedObjectID;
        }
    }

    public static final class JoinGroupMessage
    implements Serializable {
        private static final long serialVersionUID = 3257564022885855287L;
        private final Serializable data;

        public JoinGroupMessage(Serializable data) {
            this.data = data;
        }

        public Serializable getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("JoinGroupMessage[");
            sb.append(this.data).append("]");
            return sb.toString();
        }
    }

    public static final class LeaveGroupMessage
    implements Serializable {
        private static final long serialVersionUID = 3258128072350972213L;
        private final Serializable data;

        public LeaveGroupMessage(Serializable data) {
            this.data = data;
        }

        public Serializable getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("LeaveGroupMessage[");
            sb.append(this.data).append("]");
            return sb.toString();
        }
    }

    public static final class SharedObjectDisposeMessage
    implements Serializable {
        private static final long serialVersionUID = 3905241221474498104L;
        private final ID sharedObjectID;

        SharedObjectDisposeMessage(ID objID) {
            this.sharedObjectID = objID;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SharedObjectDisposeMessage[");
            sb.append(this.sharedObjectID).append("]");
            return sb.toString();
        }

        public ID getSharedObjectID() {
            return this.sharedObjectID;
        }
    }

    public static final class SharedObjectMessage
    implements Serializable {
        private static final long serialVersionUID = 3257281448531867441L;
        private final Serializable data;
        private final ID fromSharedObjectID;

        SharedObjectMessage(ID fromSharedObject, Serializable data) {
            this.fromSharedObjectID = fromSharedObject;
            this.data = data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SharedObjectMessage[");
            sb.append(this.fromSharedObjectID).append(";").append(this.data).append("]");
            return sb.toString();
        }

        public Serializable getData() {
            return this.data;
        }

        public ID getFromSharedObjectID() {
            return this.fromSharedObjectID;
        }
    }

    public static final class ViewChangeMessage
    implements Serializable {
        private static final long serialVersionUID = 3256999977782882869L;
        private final ID[] changeIDs;
        private final boolean add;
        private final Serializable data;

        ViewChangeMessage(ID[] id, boolean a, Serializable data) {
            this.changeIDs = id;
            this.add = a;
            this.data = data;
        }

        protected String printChangeIDs() {
            if (this.changeIDs == null) {
                return "null";
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.changeIDs.length) {
                buf.append(this.changeIDs[i]);
                if (i != this.changeIDs.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
            return buf.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("ViewChangeMessage[");
            sb.append(this.printChangeIDs()).append(";").append(this.add).append(";").append(this.data).append("]");
            return sb.toString();
        }

        public boolean isAdd() {
            return this.add;
        }

        public ID[] getChangeIDs() {
            return this.changeIDs;
        }

        public Serializable getData() {
            return this.data;
        }
    }
}

