/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private volatile AuthCache authCache;
    private volatile CredentialsProvider credentialsProvider;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        this.credentialsProvider.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host, Credentials creds) {
        AuthScope authScope = host != null ? new AuthScope(host.getHostName(), host.getPort()) : AuthScope.ANY;
        return this.auth(authScope, creds);
    }

    public Executor auth(String host, Credentials creds) {
        return this.auth(HttpHost.create((String)host), creds);
    }

    public Executor authPreemptive(HttpHost host) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host, basicScheme);
        return this;
    }

    public Executor authPreemptive(String host) {
        return this.authPreemptive(HttpHost.create((String)host));
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(proxy, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        return this.authPreemptiveProxy(HttpHost.create((String)proxy));
    }

    public Executor auth(Credentials cred) {
        return this.auth(AuthScope.ANY, cred);
    }

    public Executor auth(String username, String password) {
        return this.auth(new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(String username, String password, String workstation, String domain) {
        return this.auth(new NTCredentials(username, password, workstation, domain));
    }

    public Executor auth(HttpHost host, String username, String password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, String password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
        }
        return this;
    }

    @Deprecated
    public Executor cookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) throws ClientProtocolException, IOException {
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentialsProvider != null) {
            localContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (this.authCache != null) {
            localContext.setAttribute("http.auth.auth-cache", this.authCache);
        }
        if (this.cookieStore != null) {
            localContext.setAttribute("http.cookie-store", this.cookieStore);
        }
        return new Response(request.internalExecute(this.httpclient, (HttpContext)localContext));
    }

    @Deprecated
    public static void registerScheme(Scheme scheme) {
    }

    @Deprecated
    public static void unregisterScheme(String name) {
    }

    public static void closeIdleConnections() {
        CONNMGR.closeIdleConnections(0L, TimeUnit.MICROSECONDS);
    }

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException ignore) {
            }
            catch (KeyManagementException ignore) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory())).build();
        CONNMGR = new PoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)sfr);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CONNMGR.setValidateAfterInactivity(1000);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

