/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.ecf.internal.ssl.ECFCertificateException;
import org.eclipse.ecf.internal.ssl.ECFSSLServerSocketFactory;
import org.eclipse.ecf.internal.ssl.ECFSSLSocketFactory;
import org.eclipse.osgi.service.security.TrustEngine;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class ECFTrustManager
implements X509TrustManager,
BundleActivator {
    private static volatile BundleContext context;
    private volatile ServiceTracker trustEngineTracker = null;
    private ServiceRegistration socketFactoryRegistration;
    private ServiceRegistration serverSocketFactoryRegistration;

    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.verify(certs, authType);
        TrustEngine[] engines = this.getTrustEngines();
        Certificate foundCert = null;
        TrustEngine[] trustEngineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            TrustEngine engine = trustEngineArray[n2];
            try {
                foundCert = engine.findTrustAnchor((Certificate[])certs);
                if (foundCert != null) {
                    return;
                }
            }
            catch (IOException e) {
                ECFCertificateException ce = new ECFCertificateException("Error occurs when finding trust anchor in the cert chain", certs, authType);
                ce.initCause(ce);
                throw ce;
            }
            ++n2;
        }
        if (foundCert == null) {
            throw new ECFCertificateException("Valid cert chain, but no trust certificate found!", certs, authType);
        }
    }

    private void verify(X509Certificate[] certs, String authType) throws CertificateException {
        int len = certs.length;
        int i = 0;
        while (i < len) {
            X509Certificate currentX509Cert = certs[i];
            try {
                if (i == len - 1) {
                    if (currentX509Cert.getSubjectDN().equals(currentX509Cert.getIssuerDN())) {
                        currentX509Cert.verify(currentX509Cert.getPublicKey());
                    }
                } else {
                    X509Certificate nextX509Cert = certs[i + 1];
                    currentX509Cert.verify(nextX509Cert.getPublicKey());
                }
            }
            catch (Exception e) {
                ECFCertificateException ce = new ECFCertificateException("Certificate chain is not valid", certs, authType);
                ce.initCause(e);
                throw ce;
            }
            ++i;
        }
    }

    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    public void start(BundleContext context1) throws Exception {
        context = context1;
        this.socketFactoryRegistration = context1.registerService(SSLSocketFactory.class.getName(), (Object)new ECFSSLSocketFactory(), null);
        this.serverSocketFactoryRegistration = context1.registerService(SSLServerSocketFactory.class.getName(), (Object)new ECFSSLServerSocketFactory(), null);
    }

    public void stop(BundleContext context1) throws Exception {
        if (this.socketFactoryRegistration != null) {
            this.socketFactoryRegistration.unregister();
            this.socketFactoryRegistration = null;
        }
        if (this.serverSocketFactoryRegistration != null) {
            this.serverSocketFactoryRegistration.unregister();
            this.serverSocketFactoryRegistration = null;
        }
        if (this.trustEngineTracker != null) {
            this.trustEngineTracker.close();
            this.trustEngineTracker = null;
        }
        context = null;
    }

    private TrustEngine[] getTrustEngines() {
        if (this.trustEngineTracker == null) {
            this.trustEngineTracker = new ServiceTracker(context, TrustEngine.class.getName(), null);
            this.trustEngineTracker.open();
        }
        Object[] objs = this.trustEngineTracker.getServices();
        TrustEngine[] result = new TrustEngine[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }
}

