/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.start;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.start.AccountStart;
import org.eclipse.ecf.internal.example.collab.start.ConnectionDetails;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class URLListFieldEditor
extends FieldEditor {
    private org.eclipse.swt.widgets.List list;
    private SelectionListener selectionListener;
    private Button removeButton;
    private Composite buttonBox;
    private List removedConnectionDetails = new ArrayList();

    public URLListFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    URLListFieldEditor.this.removeButton = null;
                    URLListFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    private void createButtons(Composite box) {
        this.removeButton = this.createPushButton(box, Messages.URLListFieldEditor_BUTTON_REMOVE_TEXT);
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public org.eclipse.swt.widgets.List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    URLListFieldEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == URLListFieldEditor.this.removeButton) {
                    URLListFieldEditor.this.removePressed();
                } else if (widget == URLListFieldEditor.this.list) {
                    URLListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            String key = this.list.getItem(index);
            ConnectionDetails cd = (ConnectionDetails)this.list.getData(key);
            this.removeConnectionDetails(cd);
            this.list.remove(index);
            this.selectionChanged();
        }
    }

    private void removeConnectionDetails(ConnectionDetails cd) {
        this.removedConnectionDetails.add(cd);
    }

    private void selectionChanged() {
        int index = this.list.getSelectionIndex();
        this.removeButton.setEnabled(index >= 0);
    }

    protected void doLoad() {
        if (this.list != null) {
            AccountStart as = new AccountStart();
            as.loadConnectionDetailsFromPreferenceStore();
            Collection contents = as.getConnectionDetails();
            Iterator i = contents.iterator();
            while (i.hasNext()) {
                ConnectionDetails cd = (ConnectionDetails)i.next();
                String uri = String.valueOf(cd.getContainerType()) + ":" + cd.getTargetURI();
                this.list.add(uri);
                this.list.setData(uri, (Object)cd);
            }
        }
    }

    protected void doStore() {
        Iterator i = this.removedConnectionDetails.iterator();
        while (i.hasNext()) {
            ConnectionDetails cd = (ConnectionDetails)i.next();
            AccountStart as = new AccountStart();
            as.removeConnectionDetails(cd);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doLoadDefault() {
    }
}

