/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.Advertiser;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;

public final class AdvertiserImpl
implements Advertiser {
    private Locale locale;

    public AdvertiserImpl() {
        this.locale = SLPCore.DEFAULT_LOCALE;
    }

    public AdvertiserImpl(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void register(ServiceURL url, Dictionary attributes) throws ServiceLocationException {
        this.register(url, null, attributes);
    }

    @Override
    public void register(ServiceURL url, List scopes, Dictionary attributes) throws ServiceLocationException {
        ServiceRegistration reg = new ServiceRegistration(url, url.getServiceType(), scopes, SLPUtils.dictToAttrList(attributes), this.locale);
        try {
            reg.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            reg.address = SLPCore.getMyIP();
        }
        reg.port = SLPCore.SLP_PORT;
        ServiceAcknowledgement ack = (ServiceAcknowledgement)SLPCore.sendMessage(reg, true);
        if (ack.errorCode != 0) {
            throw new ServiceLocationException((short)ack.errorCode, "Registration failed");
        }
    }

    @Override
    public void deregister(ServiceURL url) throws ServiceLocationException {
        this.deregister(url, null);
    }

    @Override
    public void deregister(ServiceURL url, List scopes) throws ServiceLocationException {
        ServiceDeregistration dereg = new ServiceDeregistration(url, scopes, null, this.locale);
        try {
            dereg.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            dereg.address = SLPCore.getMyIP();
        }
        dereg.port = SLPCore.SLP_PORT;
        ServiceAcknowledgement ack = (ServiceAcknowledgement)SLPCore.sendMessage(dereg, true);
        if (ack.errorCode != 0) {
            throw new ServiceLocationException((short)ack.errorCode, "Deregistration failed");
        }
    }

    @Override
    public void addAttributes(ServiceURL url, Dictionary attributes) throws ServiceLocationException {
        throw new ServiceLocationException(16, "incremental registration not supported");
    }

    @Override
    public void deleteAttributes(ServiceURL url, Dictionary attributes) throws ServiceLocationException {
        throw new ServiceLocationException(16, "incremental registration not supported");
    }

    @Override
    public InetAddress getMyIP() {
        try {
            return SLPCore.getMyIP();
        }
        catch (Exception e) {
            return null;
        }
    }
}

