/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServerConfigParser {
    public static final String SERVER_ELEMENT = "server";
    public static final String CONNECTOR_ELEMENT = "connector";
    public static final String GROUP_ELEMENT = "group";
    public static final String PROTOCOL_ATTR = "protocol";
    public static final String HOSTNAME_ATTR = "hostname";
    public static final String PORT_ATTR = "port";
    public static final String TIMEOUT_ATTR = "timeout";
    public static final String NAME_ATTR = "name";

    protected void findElementsNamed(Node top, String name, List aList) {
        short type = top.getNodeType();
        switch (type) {
            case 10: {
                NamedNodeMap nodeMap = ((DocumentType)top).getEntities();
                int i = 0;
                while (i < nodeMap.getLength()) {
                    Entity entity = (Entity)nodeMap.item(i);
                    this.findElementsNamed(entity, name, aList);
                    ++i;
                }
                break;
            }
            case 1: {
                String elementName = top.getNodeName();
                if (name.equals(elementName)) {
                    aList.add(top);
                }
            }
            default: {
                Node child = top.getFirstChild();
                while (child != null) {
                    this.findElementsNamed(child, name, aList);
                    child = child.getNextSibling();
                }
                break block0;
            }
        }
    }

    protected List processConnectorNodes(List connectorNodes) {
        ArrayList<Connector> res = new ArrayList<Connector>();
        Iterator i = connectorNodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            String ports = this.getAttributeValue(n, PORT_ATTR);
            int port = Connector.DEFAULT_PORT;
            if (ports != null) {
                try {
                    Integer porti = Integer.valueOf(ports);
                    port = porti;
                }
                catch (NumberFormatException porti) {
                    // empty catch block
                }
            }
            String timeouts = this.getAttributeValue(n, TIMEOUT_ATTR);
            int timeout = Connector.DEFAULT_TIMEOUT;
            if (timeouts != null) {
                try {
                    Integer timeouti = Integer.valueOf(timeouts);
                    timeout = timeouti;
                }
                catch (NumberFormatException timeouti) {
                    // empty catch block
                }
            }
            String prot = this.getAttributeValue(n, PROTOCOL_ATTR);
            String host = this.getAttributeValue(n, HOSTNAME_ATTR);
            Connector c = new Connector(prot, host, port, timeout);
            this.processConnector(n, c);
            res.add(c);
        }
        return res;
    }

    protected void processConnector(Node n, Connector c) {
        ArrayList groupList = new ArrayList();
        this.findElementsNamed(n, GROUP_ELEMENT, groupList);
        Iterator i = groupList.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            String name = this.getAttributeValue(node, NAME_ATTR);
            if (name == null || name.equals("")) continue;
            NamedGroup g = new NamedGroup(name);
            c.addGroup(g);
            g.setParent(c);
        }
    }

    protected List loadConnectors(Document doc) {
        ArrayList ps = new ArrayList();
        this.findElementsNamed(doc, CONNECTOR_ELEMENT, ps);
        return this.processConnectorNodes(ps);
    }

    protected String getAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        Node attrNode = attrs.getNamedItem(attrName);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return "";
    }

    public List load(InputStream ins) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(ins);
        return this.loadConnectors(doc);
    }

    public static void main(String[] args) throws Exception {
        FileInputStream ins = new FileInputStream(args[0]);
        ServerConfigParser configParser = new ServerConfigParser();
        configParser.load(ins);
    }
}

