/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.internal.ui.wizards.ConfigurationWizardNode;
import org.eclipse.ecf.internal.ui.wizards.WizardActivityFilter;
import org.eclipse.ecf.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.ecf.internal.ui.wizards.WizardContentProvider;
import org.eclipse.ecf.internal.ui.wizards.WizardsRegistryReader;
import org.eclipse.ecf.internal.ui.wizards.WorkbenchWizardElement;
import org.eclipse.ecf.ui.ContainerConfigurationResult;
import org.eclipse.ecf.ui.IConfigurationWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;

public class ConfigurationWizardSelectionPage
extends WizardSelectionPage {
    private static final int CONTAINERTYPEDESCRIPTION_ERROR_CODE = 333;
    protected IWorkbench workbench;
    protected TreeViewer treeViewer;
    protected CategorizedWizardSelectionTree wizardSelectionTree;
    protected IStructuredSelection currentResourceSelection;

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public ConfigurationWizardSelectionPage(IWorkbench workbench, IStructuredSelection selection) {
        super(Messages.ConfigurationWizardSelectionPage_CONFIGURATION_WIZARD_PAGE_NAME);
        this.workbench = workbench;
        this.currentResourceSelection = selection;
        this.setTitle(Messages.Select);
    }

    protected ITriggerPoint getTriggerPoint() {
        return this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ecf.ui.configurationWizards");
    }

    protected ContainerConfigurationResult getContainerResult() {
        ConfigurationWizardNode cwn = (ConfigurationWizardNode)this.getSelectedNode();
        if (cwn == null) {
            return null;
        }
        return ((IConfigurationWizard)this.getSelectedNode().getWizard()).getConfigurationResult();
    }

    private ContainerTypeDescription getContainerTypeDescriptionForElement(WorkbenchWizardElement element) {
        ContainerTypeDescription typeDescription = ContainerFactory.getDefault().getDescriptionByName(element.getContainerTypeName());
        if (typeDescription == null) {
            String msg = NLS.bind((String)Messages.ConfigurationWizardSelectionPage_ERROR_MESSAGE, (Object)((Object)element));
            this.setErrorMessage(msg);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationWizardSelectionPage_CONFIGRATION_ERROR_TITLE, (String)Messages.ConfigurationWizardSelectionPage_CONFIGURATION_ERROR_MESSAGE, (IStatus)new Status(4, "org.eclipse.ecf.ui", 333, msg, null));
            return null;
        }
        return typeDescription;
    }

    protected void updateSelectedNode(WorkbenchWizardElement wizardElement) {
        this.setErrorMessage(null);
        if (wizardElement == null) {
            this.updateMessage();
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(new ConfigurationWizardNode(this.getWorkbench(), (WizardPage)this, wizardElement, this.getContainerTypeDescriptionForElement(wizardElement)));
        this.setMessage(wizardElement.getDescription());
    }

    protected IWizardCategory getRootCategory() {
        return new WizardsRegistryReader("org.eclipse.ecf.ui", "configurationWizards").getWizardElements();
    }

    public IWizardPage getNextPage() {
        ITriggerPoint triggerPoint = this.getTriggerPoint();
        if (triggerPoint == null || WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)this.getSelectedNode())) {
            return super.getNextPage();
        }
        return null;
    }

    protected Composite createTreeViewer(Composite parent) {
        IWizardCategory root = this.getRootCategory();
        this.wizardSelectionTree = new CategorizedWizardSelectionTree(root, Messages.ConfigurationWizardSelectionPage_SELECT);
        Composite importComp = this.wizardSelectionTree.createControl(parent);
        this.wizardSelectionTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationWizardSelectionPage.this.listSelectionChanged(event.getSelection());
            }
        });
        this.wizardSelectionTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigurationWizardSelectionPage.this.treeDoubleClicked(event);
            }
        });
        this.setTreeViewer(this.wizardSelectionTree.getViewer());
        return importComp;
    }

    protected void treeDoubleClicked(DoubleClickEvent event) {
        ISelection selection = event.getViewer().getSelection();
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.listSelectionChanged((ISelection)ss);
        Object element = ss.getFirstElement();
        TreeViewer v = (TreeViewer)event.getViewer();
        if (v.isExpandable(element)) {
            v.setExpandedState(element, !v.getExpandedState(element));
        } else if (element instanceof WorkbenchWizardElement && this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
        this.getContainer().showPage(this.getNextPage());
    }

    protected void listSelectionChanged(ISelection selection) {
        this.setErrorMessage(null);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object sel = ss.getFirstElement();
        if (sel instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement currentWizardSelection = (WorkbenchWizardElement)((Object)sel);
            this.updateSelectedNode(currentWizardSelection);
        } else {
            this.updateSelectedNode(null);
        }
    }

    protected void updateMessage() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            ISelection selection = viewer.getSelection();
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object sel = ss.getFirstElement();
            if (sel instanceof WorkbenchWizardElement) {
                this.updateSelectedNode((WorkbenchWizardElement)((Object)sel));
            } else {
                this.setSelectedNode(null);
            }
        } else {
            this.setMessage(null);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(1808));
        outerContainer.setFont(font);
        Composite comp = this.createTreeViewer(outerContainer);
        Dialog.applyDialogFont((Control)comp);
        this.setControl((Control)outerContainer);
    }

    protected class CategorizedWizardSelectionTree {
        private static final int SIZING_LISTS_HEIGHT = 200;
        private IWizardCategory wizardCategories;
        private String message;
        private TreeViewer viewer;

        protected CategorizedWizardSelectionTree(IWizardCategory categories, String msg) {
            this.wizardCategories = categories;
            this.message = msg;
        }

        protected Composite createControl(Composite parent) {
            Font font = parent.getFont();
            Composite outerContainer = new Composite(parent, 0);
            outerContainer.setLayout((Layout)new GridLayout());
            outerContainer.setLayoutData((Object)new GridData(1808));
            outerContainer.setFont(font);
            Label messageLabel = new Label(outerContainer, 0);
            if (this.message != null) {
                messageLabel.setText(this.message);
            }
            messageLabel.setFont(font);
            this.createFilteredTree(outerContainer);
            this.layoutTopControl(this.viewer.getControl());
            return outerContainer;
        }

        private void createFilteredTree(Composite parent) {
            FilteredTree filteredTree = new FilteredTree(parent, 2820, (PatternFilter)new WizardPatternFilter());
            this.viewer = filteredTree.getViewer();
            filteredTree.setFont(parent.getFont());
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.viewer.setComparator(new ViewerComparator(){

                public int category(Object element) {
                    if (element instanceof WizardCollectionElement) {
                        String id = ((WizardCollectionElement)((Object)element)).getId();
                        String wizardCategory = Messages.ConfigurationWizardSelectionPage_WIZARD_CATEGORY;
                        if (wizardCategory != null && wizardCategory.equals(id)) {
                            return 1;
                        }
                        String uncategorizedCategory = Messages.ConfigurationWizardSelectionPage_UNCATEGORIZED_WIZARD_CATEGORY;
                        if (uncategorizedCategory != null && uncategorizedCategory.equals(id)) {
                            return 3;
                        }
                        return 2;
                    }
                    return super.category(element);
                }
            });
            ArrayList<IWizardCategory> inputArray = new ArrayList<IWizardCategory>();
            boolean expandTop = false;
            if (this.wizardCategories != null) {
                if (this.wizardCategories.getParent() == null) {
                    IWizardCategory[] children = this.wizardCategories.getCategories();
                    int i = 0;
                    while (i < children.length) {
                        inputArray.add(children[i]);
                        ++i;
                    }
                } else {
                    expandTop = true;
                    inputArray.add(this.wizardCategories);
                }
            }
            if (expandTop) {
                this.viewer.setAutoExpandLevel(2);
            }
            AdaptableList input = new AdaptableList(inputArray);
            this.viewer.addFilter((ViewerFilter)new WizardActivityFilter());
            this.viewer.setInput((Object)input);
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }

        private void layoutTopControl(Control control) {
            GridData data = new GridData(1808);
            int availableRows = control.getParent().getDisplay().getClientArea().height / control.getParent().getFont().getFontData()[0].getHeight();
            data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
            control.setLayoutData((Object)data);
        }

        protected class WizardPatternFilter
        extends PatternFilter {
            public boolean isElementSelectable(Object element) {
                return element instanceof WorkbenchWizardElement;
            }

            protected boolean isLeafMatch(Viewer v, Object element) {
                WorkbenchWizardElement desc;
                String text;
                if (element instanceof WizardCollectionElement) {
                    return false;
                }
                return element instanceof WorkbenchWizardElement && this.wordMatches(text = (desc = (WorkbenchWizardElement)((Object)element)).getLabel());
            }
        }
    }
}

