/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.workgroup.packet.TranscriptSearch;

public class TranscriptSearchManager {
    private Connection connection;

    public TranscriptSearchManager(Connection connection) {
        this.connection = connection;
    }

    public Form getSearchForm(String serviceJID) throws XMPPException {
        TranscriptSearch search = new TranscriptSearch();
        search.setType(IQ.Type.GET);
        search.setTo(serviceJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(search.getPacketID()));
        this.connection.sendPacket(search);
        TranscriptSearch response = (TranscriptSearch)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return Form.getFormFrom(response);
    }

    public ReportedData submitSearch(String serviceJID, Form completedForm) throws XMPPException {
        TranscriptSearch search = new TranscriptSearch();
        search.setType(IQ.Type.GET);
        search.setTo(serviceJID);
        search.addExtension(completedForm.getDataFormToSend());
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(search.getPacketID()));
        this.connection.sendPacket(search);
        TranscriptSearch response = (TranscriptSearch)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return ReportedData.getReportedDataFrom(response);
    }
}

