/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.SetResponseType;

public class SetResponse {
    private static final SetResponse SR_UNKNOWN = new SetResponse(SetResponseType.UNKNOWN, null, false);
    private static final SetResponse SR_UNKNOWN_AUTH = new SetResponse(SetResponseType.UNKNOWN, null, true);
    private static final SetResponse SR_NXDOMAIN = new SetResponse(SetResponseType.NXDOMAIN, null, false);
    private static final SetResponse SR_NXDOMAIN_AUTH = new SetResponse(SetResponseType.NXDOMAIN, null, true);
    private static final SetResponse SR_NXRRSET = new SetResponse(SetResponseType.NXRRSET, null, false);
    private static final SetResponse SR_NXRRSET_AUTH = new SetResponse(SetResponseType.NXRRSET, null, true);
    private final SetResponseType type;
    private boolean isAuthenticated;
    private List<RRset> data;

    private SetResponse(SetResponseType type, RRset rrset, boolean isAuthenticated) {
        this.type = type;
        this.isAuthenticated = isAuthenticated;
        if (rrset != null) {
            this.addRRset(rrset);
        }
    }

    static SetResponse ofType(SetResponseType type) {
        return SetResponse.ofType(type, null, false);
    }

    static SetResponse ofType(SetResponseType type, RRset rrset) {
        return SetResponse.ofType(type, rrset, false);
    }

    static SetResponse ofType(SetResponseType type, Cache.CacheRRset rrset) {
        return SetResponse.ofType(type, rrset, rrset.isAuthenticated());
    }

    static SetResponse ofType(SetResponseType type, RRset rrset, boolean isAuthenticated) {
        switch (type) {
            case UNKNOWN: {
                return isAuthenticated ? SR_UNKNOWN_AUTH : SR_UNKNOWN;
            }
            case NXDOMAIN: {
                return isAuthenticated ? SR_NXDOMAIN_AUTH : SR_NXDOMAIN;
            }
            case NXRRSET: {
                return isAuthenticated ? SR_NXRRSET_AUTH : SR_NXRRSET;
            }
            case DELEGATION: 
            case CNAME: 
            case DNAME: 
            case SUCCESSFUL: {
                return new SetResponse(type, rrset, isAuthenticated);
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    void addRRset(RRset rrset) {
        if (this.type.isSealed()) {
            throw new IllegalStateException("Attempted to add RRset to sealed response of type " + (Object)((Object)this.type));
        }
        if (this.data == null) {
            this.data = new ArrayList<RRset>();
            if (rrset instanceof Cache.CacheRRset) {
                this.isAuthenticated = ((Cache.CacheRRset)rrset).isAuthenticated();
            }
        } else if (rrset instanceof Cache.CacheRRset && this.isAuthenticated) {
            this.isAuthenticated = ((Cache.CacheRRset)rrset).isAuthenticated();
        }
        this.data.add(rrset);
    }

    public boolean isUnknown() {
        return this.type == SetResponseType.UNKNOWN;
    }

    public boolean isNXDOMAIN() {
        return this.type == SetResponseType.NXDOMAIN;
    }

    public boolean isNXRRSET() {
        return this.type == SetResponseType.NXRRSET;
    }

    public boolean isDelegation() {
        return this.type == SetResponseType.DELEGATION;
    }

    public boolean isCNAME() {
        return this.type == SetResponseType.CNAME;
    }

    public boolean isDNAME() {
        return this.type == SetResponseType.DNAME;
    }

    public boolean isSuccessful() {
        return this.type == SetResponseType.SUCCESSFUL;
    }

    public List<RRset> answers() {
        if (this.type != SetResponseType.SUCCESSFUL) {
            return null;
        }
        return this.data;
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)this.data.get(0).first();
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)this.data.get(0).first();
    }

    public RRset getNS() {
        return this.data != null ? this.data.get(0) : null;
    }

    public String toString() {
        return (Object)((Object)this.type) + (this.type.isPrintRecords() ? ": " + this.data.get(0) : "");
    }

    @Generated
    boolean isAuthenticated() {
        return this.isAuthenticated;
    }
}

