/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.xmpp;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.internal.provider.xmpp.XMPPChatRoomContainer;
import org.eclipse.ecf.internal.provider.xmpp.XMPPChatRoomManager;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerAccountManager;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerContext;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerPresenceHelper;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.events.IQEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.MessageEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.PresenceEvent;
import org.eclipse.ecf.internal.provider.xmpp.filetransfer.XMPPOutgoingFileTransferHelper;
import org.eclipse.ecf.internal.provider.xmpp.search.XMPPUserSearchManager;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionObjectPacketEvent;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionPacketEvent;
import org.eclipse.ecf.presence.IAccountManager;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.search.IUserSearchManager;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.IAsynchEventHandler;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOConfig;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SOContext;
import org.eclipse.ecf.provider.generic.SOWrapper;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.osgi.util.NLS;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.packet.XHTMLExtension;

public class XMPPContainer
extends ClientSOContainer
implements IPresenceService {
    public static final int DEFAULT_KEEPALIVE = 30000;
    public static final String CONNECT_NAMESPACE = XmppPlugin.getDefault().getNamespaceIdentifier();
    public static final String CONTAINER_HELPER_ID = String.valueOf(XMPPContainer.class.getName()) + ".xmpphandler";
    protected static final String GOOGLE_SERVICENAME = "gmail.com";
    private static final String[] googleHosts = new String[]{"gmail.com", "talk.google.com", "googlemail.com"};
    public static final String XMPP_GOOGLE_OVERRIDE_PROP_NAME = "ecf.xmpp.google.override";
    private static Set googleNames = new HashSet();
    protected int keepAlive = 0;
    XMPPContainerAccountManager accountManager = null;
    XMPPChatRoomManager chatRoomManager = null;
    XMPPOutgoingFileTransferHelper outgoingFileTransferContainerAdapter = null;
    XMPPContainerPresenceHelper presenceHelper = null;
    XMPPUserSearchManager searchManager = null;
    protected ID presenceHelperID = null;

    static {
        int i = 0;
        while (i < googleHosts.length) {
            googleNames.add(googleHosts[i]);
            ++i;
        }
        String override = System.getProperty(XMPP_GOOGLE_OVERRIDE_PROP_NAME);
        if (override != null) {
            googleNames.add(override.toLowerCase());
        }
    }

    protected XMPPContainer(SOContainerConfig config, int keepAlive) throws Exception {
        super((ISharedObjectContainerConfig)config);
        this.keepAlive = keepAlive;
        this.accountManager = new XMPPContainerAccountManager();
        this.chatRoomManager = new XMPPChatRoomManager(this.getID());
        this.searchManager = new XMPPUserSearchManager();
        this.presenceHelperID = IDFactory.getDefault().createStringID(CONTAINER_HELPER_ID);
        this.presenceHelper = new XMPPContainerPresenceHelper(this);
        this.outgoingFileTransferContainerAdapter = new XMPPOutgoingFileTransferHelper(this);
    }

    public XMPPContainer() throws Exception {
        this(30000);
    }

    public XMPPContainer(int ka) throws Exception {
        this(new SOContainerConfig(IDFactory.getDefault().createGUID()), ka);
    }

    public XMPPContainer(String userhost, int ka) throws Exception {
        this(new SOContainerConfig(IDFactory.getDefault().createStringID(userhost)), ka);
    }

    protected boolean verifySharedObjectMessageTarget(ID containerID) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ContainerMessage data) throws IOException {
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            ID connectedID = this.getConnectedID();
            if (connectedID == null) {
                throw new ConnectException("Container not connected");
            }
            Object object = this.getGroupMembershipLock();
            synchronized (object) {
                if (!connectedID.equals((Object)data.getToContainerID())) {
                    this.queueContainerMessage(data);
                }
            }
        }
    }

    public IRosterManager getRosterManager() {
        return this.presenceHelper.getRosterManager();
    }

    public IUserSearchManager getUserSearchManager() {
        return this.searchManager;
    }

    public IAccountManager getAccountManager() {
        return this.accountManager;
    }

    public IChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public IChatManager getChatManager() {
        return this.presenceHelper.getChatManager();
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(XmppPlugin.getDefault().getNamespaceIdentifier());
    }

    public void connect(ID remote, IConnectContext joinContext) throws ContainerConnectException {
        try {
            this.getSharedObjectManager().addSharedObject(this.presenceHelperID, (ISharedObject)this.presenceHelper, null);
            super.connect(remote, joinContext);
            XmppPlugin.getDefault().registerService(this);
        }
        catch (ContainerConnectException e) {
            this.disconnect();
            throw e;
        }
        catch (SharedObjectAddException e1) {
            this.disconnect();
            throw new ContainerConnectException(NLS.bind((String)Messages.XMPPContainer_EXCEPTION_ADDING_SHARED_OBJECT, (Object)this.presenceHelperID), (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ID groupID = this.getConnectedID();
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), groupID));
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            if (this.isConnected()) {
                ISynchAsynchConnection conn;
                XmppPlugin.getDefault().unregisterService(this);
                ISynchAsynchConnection iSynchAsynchConnection = conn = this.getConnection();
                synchronized (iSynchAsynchConnection) {
                    Object object = this.getGroupMembershipLock();
                    synchronized (object) {
                        this.handleLeave(groupID, (IConnection)conn);
                    }
                }
            }
            this.connection = null;
            this.remoteServerID = null;
            this.accountManager.setConnection(null);
            this.chatRoomManager.setConnection(null, null, null);
            this.outgoingFileTransferContainerAdapter.setConnection(null);
            this.presenceHelper.disconnect();
            this.getSharedObjectManager().removeSharedObject(this.presenceHelperID);
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), groupID));
    }

    public void dispose() {
        this.chatRoomManager.dispose();
        this.accountManager.dispose();
        this.outgoingFileTransferContainerAdapter.dispose();
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IPresenceContainerAdapter.class)) {
            return this;
        }
        if (clazz.equals(ISendFileTransferContainerAdapter.class)) {
            return this.outgoingFileTransferContainerAdapter;
        }
        return super.getAdapter(clazz);
    }

    private String trimResourceFromJid(String jid) {
        int slashIndex = jid.indexOf(47);
        if (slashIndex > 0) {
            return jid.substring(slashIndex + 1);
        }
        return null;
    }

    private void resetTargetResource(ID originalTarget, Object serverData) {
        if (originalTarget instanceof XMPPID) {
            String jid;
            String jidResource;
            XMPPID xmppOriginalTarget = (XMPPID)originalTarget;
            if (serverData != null && serverData instanceof String && (jidResource = this.trimResourceFromJid(jid = (String)serverData)) != null) {
                xmppOriginalTarget.setResourceName(jidResource);
            }
        }
    }

    protected ID handleConnectResponse(ID originalTarget, Object serverData) throws Exception {
        if (originalTarget != null && !originalTarget.equals((Object)this.getID())) {
            this.resetTargetResource(originalTarget, serverData);
            this.addNewRemoteMember(originalTarget, null);
            ECFConnection conn = this.getECFConnection();
            this.accountManager.setConnection(conn.getXMPPConnection());
            this.chatRoomManager.setConnection(this.getConnectNamespace(), originalTarget, conn);
            this.searchManager.setConnection(this.getConnectNamespace(), originalTarget, conn);
            this.searchManager.setEnabled(!this.isGoogle(originalTarget));
            this.presenceHelper.setUser((IUser)new User(originalTarget));
            this.outgoingFileTransferContainerAdapter.setConnection(conn.getXMPPConnection());
            return originalTarget;
        }
        throw new ConnectException(Messages.XMPPContainer_EXCEPTION_INVALID_RESPONSE_FROM_SERVER);
    }

    protected ISynchAsynchConnection createConnection(ID remoteSpace, Object data) throws ConnectionCreateException {
        boolean google = this.isGoogle(remoteSpace);
        return new ECFConnection(google, this.getConnectNamespace(), (IAsynchEventHandler)this.receiver);
    }

    protected boolean isGoogle(ID remoteSpace) {
        if (remoteSpace instanceof XMPPID) {
            XMPPID theID = (XMPPID)remoteSpace;
            String host = theID.getHostname();
            if (host == null) {
                return false;
            }
            return googleNames.contains(host.toLowerCase());
        }
        return false;
    }

    protected Object getConnectData(ID remote, IConnectContext joinContext) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = this.createAuthorizationCallbacks();
        if (joinContext != null && callbacks != null && callbacks.length > 0) {
            CallbackHandler handler = joinContext.getCallbackHandler();
            if (handler != null) {
                handler.handle(callbacks);
            }
            if (callbacks[0] instanceof ObjectCallback) {
                ObjectCallback cb = (ObjectCallback)callbacks[0];
                return cb.getObject();
            }
        }
        return null;
    }

    protected Object createConnectData(ID target, Callback[] cbs, Object data) {
        if (cbs.length > 0 && cbs[0] instanceof ObjectCallback) {
            ObjectCallback cb = (ObjectCallback)cbs[0];
            return cb.getObject();
        }
        return data;
    }

    protected Callback[] createAuthorizationCallbacks() {
        Callback[] cbs = new Callback[]{new ObjectCallback()};
        return cbs;
    }

    protected int getConnectTimeout() {
        return this.keepAlive;
    }

    protected Roster getRoster() throws IOException {
        ECFConnection connection = this.getECFConnection();
        if (connection != null) {
            return connection.getRoster();
        }
        return null;
    }

    protected void deliverEvent(Event evt) {
        SOWrapper wrap = this.getSharedObjectWrapper(this.presenceHelperID);
        if (wrap != null) {
            wrap.deliverEvent(evt);
        }
    }

    protected void handleXMPPMessage(Packet aPacket) throws IOException {
        if (!this.handleAsExtension(aPacket)) {
            if (aPacket instanceof IQ) {
                this.deliverEvent(new IQEvent((IQ)aPacket));
            } else if (aPacket instanceof Message) {
                this.deliverEvent(new MessageEvent((Message)aPacket));
            } else if (aPacket instanceof Presence) {
                this.deliverEvent(new PresenceEvent((Presence)aPacket));
            } else {
                this.log(NLS.bind((String)Messages.XMPPContainer_UNEXPECTED_XMPP_MESSAGE, (Object)aPacket.toXML()), null);
            }
        }
    }

    protected boolean handleAsExtension(Packet packet) {
        for (Object extension : packet.getExtensions()) {
            if (extension instanceof XHTMLExtension) {
                XHTMLExtension xhtmlExtension = (XHTMLExtension)extension;
                this.deliverEvent(new MessageEvent((Message)packet, xhtmlExtension.getBodies()));
                return true;
            }
            if (!(packet instanceof Presence) || !(extension instanceof MUCUser)) continue;
            return true;
        }
        return false;
    }

    protected SOContext createSharedObjectContext(SOConfig soconfig, IQueueEnqueue queue) {
        return new XMPPContainerContext(soconfig.getSharedObjectID(), soconfig.getHomeContainerID(), (SOContainer)this, soconfig.getProperties(), queue);
    }

    protected void processAsynch(AsynchEvent e) {
        try {
            if (e instanceof ECFConnectionPacketEvent) {
                this.handleXMPPMessage((Packet)e.getData());
                return;
            }
            if (e instanceof ECFConnectionObjectPacketEvent) {
                ECFConnectionObjectPacketEvent evt = (ECFConnectionObjectPacketEvent)e;
                Object obj = evt.getObjectValue();
                ContainerMessage cm = XMPPContainer.deserializeContainerMessage((byte[])((byte[])obj));
                if (cm == null) {
                    throw new IOException(Messages.XMPPContainer_EXCEPTION_DESERIALIZED_OBJECT_NULL);
                }
                ContainerMessage contMessage = cm;
                IChatRoomContainer chat = this.chatRoomManager.findReceiverChatRoom(contMessage.getToContainerID());
                if (chat != null && chat instanceof XMPPChatRoomContainer) {
                    XMPPChatRoomContainer cont = (XMPPChatRoomContainer)chat;
                    cont.handleContainerMessage(contMessage);
                    return;
                }
                Serializable data = contMessage.getData();
                if (data instanceof ContainerMessage.CreateMessage) {
                    this.handleCreateMessage(contMessage);
                } else if (data instanceof ContainerMessage.CreateResponseMessage) {
                    this.handleCreateResponseMessage(contMessage);
                } else if (data instanceof ContainerMessage.SharedObjectMessage) {
                    this.handleSharedObjectMessage(contMessage);
                } else if (data instanceof ContainerMessage.SharedObjectDisposeMessage) {
                    this.handleSharedObjectDisposeMessage(contMessage);
                } else {
                    this.debug(NLS.bind((String)Messages.XMPPContainer_UNRECOGONIZED_CONTAINER_MESSAGE, (Object)contMessage));
                }
            } else {
                this.log(NLS.bind((String)Messages.XMPPContainer_UNEXPECTED_EVENT, (Object)e), null);
            }
        }
        catch (Exception except) {
            this.log(NLS.bind((String)Messages.XMPPContainer_EXCEPTION_HANDLING_ASYCH_EVENT, (Object)e), except);
        }
    }

    public ECFConnection getECFConnection() {
        return (ECFConnection)super.getConnection();
    }

    public XMPPConnection getXMPPConnection() {
        ECFConnection conn = this.getECFConnection();
        if (conn == null) {
            return null;
        }
        return conn.getXMPPConnection();
    }

    protected void log(String msg, Throwable e) {
        XmppPlugin.log(msg, e);
    }
}

