/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient4;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.provider.filetransfer.events.socket.AbstractSocketWrapper;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketClosedEvent;

class CloseMonitoringSocket
extends AbstractSocketWrapper {
    private boolean closed = false;
    private final ISocketListener spyListener;
    private final ISocketEventSource source;
    private Socket wrappedSocket;

    public CloseMonitoringSocket(Socket toWrap, ISocketListener spyListener, ISocketEventSource source) {
        super(toWrap);
        this.spyListener = spyListener;
        this.source = source;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("closing socket " + this.toString()));
                super.close();
            }
            catch (Throwable throwable) {
                this.fireEvent((ISocketEvent)new SocketClosedEvent(this.source, this.getSocket(), (Socket)(this.wrappedSocket != null ? this.wrappedSocket : this)));
                throw throwable;
            }
            this.fireEvent((ISocketEvent)new SocketClosedEvent(this.source, this.getSocket(), (Socket)(this.wrappedSocket != null ? this.wrappedSocket : this)));
        }
    }

    private void fireEvent(ISocketEvent event) {
        if (this.spyListener != null) {
            this.spyListener.handleSocketEvent(event);
        }
        event.getSource().fireEvent(event);
    }

    public boolean isSecure() {
        return this.getSocket() instanceof SSLSocket;
    }

    Socket getWrappedSocket() {
        return this.wrappedSocket;
    }

    void setWrappedSocket(Socket wrappedSocket) {
        this.wrappedSocket = wrappedSocket;
    }
}

