/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiatorManager;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.Bytestream;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Socks5TransferNegotiatorManager
implements FileTransferNegotiatorManager {
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    private final Object proxyLock = new Object();
    private static ProxyProcess proxyProcess;
    private final Object processLock = new Object();
    private final Cache<String, Integer> addressBlacklist = new Cache(100, 0x6DDD00L);
    private XMPPConnection connection;
    private List<String> proxies;
    private List<Bytestream.StreamHost> streamHosts;

    public Socks5TransferNegotiatorManager(XMPPConnection connection) {
        this.connection = connection;
    }

    @Override
    public StreamNegotiator createNegotiator() {
        return new Socks5TransferNegotiator(this, this.connection);
    }

    public void incrementConnectionFailures(String address) {
        Integer count = this.addressBlacklist.get(address);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.addressBlacklist.put(address, count);
    }

    public int getConnectionFailures(String address) {
        Integer count = this.addressBlacklist.get(address);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyProcess addTransfer() throws IOException {
        Object object = this.processLock;
        synchronized (object) {
            if (proxyProcess == null) {
                proxyProcess = new ProxyProcess(new ServerSocket(7777));
                proxyProcess.start();
            }
        }
        proxyProcess.addTransfer();
        return proxyProcess;
    }

    public void removeTransfer() {
        if (proxyProcess == null) {
            return;
        }
        proxyProcess.removeTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Bytestream.StreamHost> getStreamHosts() {
        Object object = this.proxyLock;
        synchronized (object) {
            if (this.proxies == null) {
                this.initProxies();
            }
        }
        return Collections.unmodifiableCollection(this.streamHosts);
    }

    private String checkIsProxy(ServiceDiscoveryManager manager, DiscoverItems.Item item) {
        DiscoverInfo info;
        try {
            info = manager.discoverInfo(item.getEntityID());
        }
        catch (XMPPException e) {
            return null;
        }
        Iterator<DiscoverInfo.Identity> itx = info.getIdentities();
        while (itx.hasNext()) {
            DiscoverInfo.Identity identity = itx.next();
            if (!"proxy".equalsIgnoreCase(identity.getCategory()) || !"bytestreams".equalsIgnoreCase(identity.getType())) continue;
            return info.getFrom();
        }
        return null;
    }

    private void initProxies() {
        this.proxies = new ArrayList<String>();
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            DiscoverItems discoItems = manager.discoverItems(this.connection.getServiceName());
            Iterator<DiscoverItems.Item> it = discoItems.getItems();
            while (it.hasNext()) {
                DiscoverItems.Item item = it.next();
                String proxy = this.checkIsProxy(manager, item);
                if (proxy == null) continue;
                this.proxies.add(proxy);
            }
        }
        catch (XMPPException e) {
            return;
        }
        if (this.proxies.size() > 0) {
            this.initStreamHosts();
        }
    }

    private void initStreamHosts() {
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        Iterator<String> it = this.proxies.iterator();
        while (it.hasNext()) {
            String jid = it.next().toString();
            IQ query = new IQ(){

                public String getChildElementXML() {
                    return "<query xmlns=\"http://jabber.org/protocol/bytestreams\"/>";
                }
            };
            query.setType(IQ.Type.GET);
            query.setTo(jid);
            PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(query.getPacketID()));
            this.connection.sendPacket(query);
            Bytestream response = (Bytestream)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            if (response != null) {
                streamHosts.addAll(response.getStreamHosts());
            }
            collector.cancel();
        }
        this.streamHosts = streamHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.processLock;
        synchronized (object) {
            if (proxyProcess != null) {
                proxyProcess.stop();
                proxyProcess = null;
            }
        }
    }

    class ProxyProcess
    implements Runnable {
        private final ServerSocket listeningSocket;
        private final Map<String, Socket> connectionMap = new HashMap<String, Socket>();
        private boolean done = false;
        private Thread thread = new Thread((Runnable)this, "File Transfer Connection Listener");
        private int transfers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.listeningSocket.setSoTimeout(10000);
                    ** GOTO lbl13
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    try {
                        this.listeningSocket.close();
                        return;
                    }
                    catch (IOException var5_3) {
                        // empty catch block
                    }
                    return;
lbl13:
                    // 1 sources

                    if (true) ** GOTO lbl70
                }
            }
            catch (Throwable var4_13) {
                try {
                    this.listeningSocket.close();
                    throw var4_13;
                }
                catch (IOException var5_4) {
                    // empty catch block
                }
                throw var4_13;
            }
            do {
                conn = null;
                var2_6 = this;
                synchronized (var2_6) {
                    while (true) {
                        if (this.transfers > 0 || this.done) {
                            break;
                        }
                        this.transfers = -1;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var3_11) {
                            // empty catch block
                        }
                    }
                }
                if (this.done) break;
                try {
                    var2_6 = this.listeningSocket;
                    synchronized (var2_6) {
                        conn = this.listeningSocket.accept();
                    }
                    if (conn == null) continue;
                    digest = this.establishSocks5UploadConnection(conn);
                    var3_10 = this.connectionMap;
                    synchronized (var3_10) {
                        this.connectionMap.put(digest, conn);
                    }
                }
                catch (SocketTimeoutException digest) {
                }
                catch (IOException digest) {
                }
                catch (XMPPException e) {
                    e.printStackTrace();
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (IOException var3_12) {
                        // empty catch block
                    }
                }
lbl70:
                // 8 sources

            } while (!this.done);
            try {
                this.listeningSocket.close();
                return;
            }
            catch (IOException var5_5) {
                // empty catch block
            }
        }

        private String establishSocks5UploadConnection(Socket connection) throws XMPPException, IOException {
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            DataInputStream in = new DataInputStream(connection.getInputStream());
            int b = ((InputStream)in).read();
            if (b != 5) {
                throw new XMPPException("Only SOCKS5 supported");
            }
            b = ((InputStream)in).read();
            int[] auth = new int[b];
            int i = 0;
            while (i < b) {
                auth[i] = ((InputStream)in).read();
                ++i;
            }
            int authMethod = -1;
            int[] nArray = auth;
            int n = auth.length;
            int n2 = 0;
            while (n2 < n) {
                int anAuth = nArray[n2];
                int n3 = authMethod = anAuth == 0 ? 0 : -1;
                if (authMethod == 0) break;
                ++n2;
            }
            if (authMethod != 0) {
                throw new XMPPException("Authentication method not supported");
            }
            byte[] cmd = new byte[]{5, 0};
            ((OutputStream)out).write(cmd);
            String responseDigest = Socks5TransferNegotiator.createIncomingSocks5Message(in);
            cmd = Socks5TransferNegotiator.createOutgoingSocks5Message(0, responseDigest);
            if (!connection.isConnected()) {
                throw new XMPPException("Socket closed by remote user");
            }
            ((OutputStream)out).write(cmd);
            return responseDigest;
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.done = true;
            Object object = this;
            synchronized (object) {
                this.notify();
            }
            object = this.listeningSocket;
            synchronized (object) {
                this.listeningSocket.notify();
            }
        }

        public int getPort() {
            return this.listeningSocket.getLocalPort();
        }

        ProxyProcess(ServerSocket listeningSocket) {
            this.listeningSocket = listeningSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket(String digest) {
            Map<String, Socket> map = this.connectionMap;
            synchronized (map) {
                return this.connectionMap.get(digest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                if (this.transfers == -1) {
                    this.transfers = 1;
                    this.notify();
                } else {
                    ++this.transfers;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                --this.transfers;
            }
        }
    }
}

