/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.bittorrent.ui;

import java.io.File;
import org.eclipse.ecf.internal.provider.bittorrent.ui.Activator;
import org.eclipse.ecf.internal.provider.bittorrent.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class BitTorrentConnectWizardPage
extends WizardPage {
    private Text torrentText;
    private Text targetText;
    private Button browseTorrentBtn;
    private Button browseTargetBtn;
    private String torrentFile;

    BitTorrentConnectWizardPage() {
        super("");
        this.setTitle(Messages.getString("BitTorrentConnectWizardPage.File_Sharing"));
        this.setDescription(Messages.getString("BitTorrentConnectWizardPage.File_Sharing.Description"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.ecf.provider.bittorrent.ui", (String)"icons/filewiz_download.png"));
        this.setPageComplete(false);
    }

    BitTorrentConnectWizardPage(String torrentFile) {
        this();
        this.torrentFile = torrentFile;
    }

    private void addListeners() {
        this.torrentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = BitTorrentConnectWizardPage.this.torrentText.getText().trim();
                if (file.equals("")) {
                    BitTorrentConnectWizardPage.this.setErrorMessage(Messages.getString("BitTorrentConnectWizardPage.file_must_be_entered"));
                } else {
                    File torrent = new File(file);
                    if (torrent.isDirectory()) {
                        BitTorrentConnectWizardPage.this.setErrorMessage(Messages.getString("BitTorrentConnectWizardPage.path_is_mapped"));
                    } else if (!torrent.canRead()) {
                        BitTorrentConnectWizardPage.this.setErrorMessage(Messages.getString("BitTorrentConnectWizardPage.file_cannot_read"));
                    } else {
                        BitTorrentConnectWizardPage.this.setErrorMessage(null);
                    }
                }
            }
        });
        this.targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String target = BitTorrentConnectWizardPage.this.torrentText.getText().trim();
                if (target.equals("")) {
                    BitTorrentConnectWizardPage.this.setErrorMessage(Messages.getString("BitTorrentConnectWizardPage.destination_must_set"));
                } else {
                    BitTorrentConnectWizardPage.this.setErrorMessage(null);
                }
            }
        });
        this.browseTorrentBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String torrent;
                FileDialog dialog = new FileDialog(BitTorrentConnectWizardPage.this.browseTorrentBtn.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.torrent"});
                if (BitTorrentConnectWizardPage.this.torrentFile != null) {
                    int lastIndex = BitTorrentConnectWizardPage.this.torrentFile.lastIndexOf(47);
                    if (lastIndex == -1) {
                        lastIndex = BitTorrentConnectWizardPage.this.torrentFile.lastIndexOf(92);
                    }
                    if (lastIndex != -1) {
                        dialog.setFilterPath(BitTorrentConnectWizardPage.this.torrentFile.substring(0, lastIndex));
                    }
                }
                if ((torrent = dialog.open()) != null) {
                    BitTorrentConnectWizardPage.this.torrentText.setText(torrent);
                }
            }
        });
        this.browseTargetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BitTorrentConnectWizardPage.this.browseTorrentBtn.getShell(), 4096);
                String target = dialog.open();
                if (target != null) {
                    BitTorrentConnectWizardPage.this.targetText.setText(target);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 0x1000000, true, false);
        Label label = new Label(parent, 16384);
        label.setText(Messages.getString("BitTorrentConnectWizardPage.Torrent"));
        this.torrentText = new Text(parent, 2052);
        this.torrentText.setLayoutData((Object)data);
        this.browseTorrentBtn = new Button(parent, 8);
        this.browseTorrentBtn.setText(Messages.getString("BitTorrentConnectWizardPage.Browse1"));
        label = new Label(parent, 16384);
        label.setText(Messages.getString("BitTorrentConnectWizardPage.Target_Path"));
        this.targetText = new Text(parent, 2052);
        this.targetText.setLayoutData((Object)data);
        this.browseTargetBtn = new Button(parent, 8);
        this.browseTargetBtn.setText(Messages.getString("BitTorrentConnectWizardPage.Browse2"));
        if (this.torrentFile != null) {
            this.torrentText.setText(this.torrentFile);
            this.targetText.setFocus();
        }
        this.addListeners();
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    String getTorrentName() {
        return this.torrentText.getText();
    }

    String getTargetName() {
        return this.targetText.getText();
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

