/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.remoteservices.ui.Activator;
import org.eclipse.ecf.internal.remoteservices.ui.DiscoveryComponent;
import org.eclipse.ecf.internal.remoteservices.ui.Messages;
import org.eclipse.ecf.internal.remoteservices.ui.RSAImageRegistry;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.AbstractEndpointNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointAsyncInterfacesNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointConfigTypesNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointConnectTargetIDNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointContentProvider;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointDiscoveryGroupNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointFrameworkIDNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointHostGroupNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointIDNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointIntentsNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointInterfacesNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointNamespaceNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointPackageVersionNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointPropertyNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointRemoteServiceFilterNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointRemoteServiceIDNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointServiceIDNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointTimestampNode;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.ImportRegistrationNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleException;
import org.osgi.service.remoteserviceadmin.EndpointEvent;

public class EndpointDiscoveryView
extends ViewPart {
    public static final String ID_VIEW = "org.eclipse.ecf.remoteserviceadmin.ui.views.EndpointDiscoveryView";
    private TreeViewer viewer;
    private Action startRSAAction;
    private Action copyValueAction;
    private Action copyNameAction;
    private Action importAction;
    private Action unimportAction;
    private Action undiscoverAction;
    private Action edefDiscoverAction;
    private Clipboard clipboard;
    private DiscoveryComponent discovery;
    private EndpointContentProvider contentProvider;
    private int previousRegistryBrowserGroupBy;

    public void createPartControl(Composite parent) {
        this.discovery = DiscoveryComponent.getDefault();
        this.discovery.setView(this);
        IViewSite viewSite = this.getViewSite();
        this.contentProvider = new EndpointContentProvider(viewSite, Messages.EndpointDiscoveryView_ENDPOINT_ROOT_NAME);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)viewSite);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.clipboard = new Clipboard(this.viewer.getControl().getDisplay());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IEndpointDescriptionLocator locator = this.discovery.getEndpointDescriptionLocator();
        if (locator != null) {
            EndpointDescription[] eds;
            EndpointDescription[] endpointDescriptionArray = eds = locator.getDiscoveredEndpoints();
            int n = eds.length;
            int n2 = 0;
            while (n2 < n) {
                EndpointDescription ed = endpointDescriptionArray[n2];
                this.addEndpoint(ed);
                ++n2;
            }
        }
        this.showServicesInRegistryBrowser();
    }

    private int invokeShowGroupBy(RegistryBrowser registryBrowser, int groupBy) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)registryBrowser.getClass().getDeclaredMethod("showGroupBy", Integer.TYPE).invoke((Object)registryBrowser, groupBy);
    }

    private int showInRegistryBrowser(int groupBy) {
        try {
            IViewPart view;
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (view = page.findView("org.eclipse.pde.runtime.RegistryBrowser")) != null) {
                return this.invokeShowGroupBy((RegistryBrowser)view, 2);
            }
        }
        catch (Exception e) {
            this.logWarning("Could not show services in PDE Plugin view", e);
        }
        return 0;
    }

    private void showServicesInRegistryBrowser() {
        this.previousRegistryBrowserGroupBy = this.showInRegistryBrowser(2);
    }

    public void dispose() {
        this.showInRegistryBrowser(this.previousRegistryBrowserGroupBy);
        super.dispose();
        this.viewer = null;
        this.contentProvider = null;
        if (this.discovery != null) {
            this.discovery.setView(null);
            this.discovery = null;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EndpointDiscoveryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.startRSAAction);
        bars.getMenuManager().add((IAction)this.edefDiscoverAction);
        bars.getToolBarManager().add((IAction)this.startRSAAction);
        bars.getToolBarManager().add((IAction)this.edefDiscoverAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        if (selection != null) {
            Object e = selection.getFirstElement();
            if (e instanceof EndpointPropertyNode) {
                manager.add((IAction)this.copyNameAction);
                manager.add((IAction)this.copyValueAction);
            } else if (e instanceof EndpointNode) {
                EndpointNode edNode = (EndpointNode)e;
                RemoteServiceAdmin.ImportRegistration ir = edNode.getImportRegistration();
                if (ir == null) {
                    manager.add((IAction)this.importAction);
                    manager.add((IAction)this.undiscoverAction);
                } else {
                    manager.add((IAction)this.unimportAction);
                }
            }
        }
    }

    private void log(int level, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.ecf.remoteservice.ui", message, e));
    }

    private void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    private void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    private void makeActions() {
        this.startRSAAction = new Action(){

            public void run() {
                if (EndpointDiscoveryView.this.discovery != null) {
                    try {
                        EndpointDiscoveryView.this.discovery.startRSA();
                        EndpointDiscoveryView.this.startRSAAction.setEnabled(false);
                    }
                    catch (BundleException e) {
                        EndpointDiscoveryView.this.logError(Messages.EndpointDiscoveryView_ERROR_RSA_START_FAILED, e);
                        EndpointDiscoveryView.this.showMessage(String.valueOf(Messages.EndpointDiscoveryView_ERROR_MSG_RSA_START_PREFIX) + e.getMessage() + Messages.EndpointDiscoveryView_ERROR_MSG_SUFFIX);
                    }
                }
            }
        };
        this.startRSAAction.setText(Messages.EndpointDiscoveryView_START_RSA);
        this.startRSAAction.setToolTipText(Messages.EndpointDiscoveryView_START_RSA_SERVICE);
        this.startRSAAction.setEnabled(this.discovery.getRSA() == null);
        this.copyValueAction = new Action(){

            public void run() {
                Object o = ((ITreeSelection)EndpointDiscoveryView.this.viewer.getSelection()).getFirstElement();
                String data = ((EndpointPropertyNode)o).getPropertyValue().toString();
                if (data != null && data.length() > 0) {
                    EndpointDiscoveryView.this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.copyValueAction.setText(Messages.EndpointDiscoveryView_COPY_PROPERTY_VALUE);
        this.copyValueAction.setToolTipText(Messages.EndpointDiscoveryView_COPY_PROPERTY_VALUE);
        this.copyValueAction.setImageDescriptor(RSAImageRegistry.DESC_PROPERTY_OBJ);
        this.copyNameAction = new Action(){

            public void run() {
                Object o = ((ITreeSelection)EndpointDiscoveryView.this.viewer.getSelection()).getFirstElement();
                String data = ((EndpointPropertyNode)o).getPropertyName();
                if (data != null && data.length() > 0) {
                    EndpointDiscoveryView.this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.copyNameAction.setText(Messages.EndpointDiscoveryView_COPY_PROPERTY_NAME);
        this.copyNameAction.setToolTipText(Messages.EndpointDiscoveryView_COPY_PROPERTY_NAME);
        this.copyNameAction.setImageDescriptor(RSAImageRegistry.DESC_PROPERTY_OBJ);
        this.importAction = new Action(){

            public void run() {
                EndpointNode edNode = EndpointDiscoveryView.this.getEDNodeSelected();
                if (edNode != null) {
                    RemoteServiceAdmin rsa = EndpointDiscoveryView.this.discovery.getRSA();
                    if (rsa == null) {
                        EndpointDiscoveryView.this.showMessage(Messages.EndpointDiscoveryView_ERROR_MSG_RSA_IS_NULL);
                    } else {
                        EndpointDescription ed = edNode.getEndpointDescription();
                        RemoteServiceAdmin.ImportRegistration reg = (RemoteServiceAdmin.ImportRegistration)rsa.importService((org.osgi.service.remoteserviceadmin.EndpointDescription)ed);
                        Throwable exception = reg.getException();
                        if (exception != null) {
                            EndpointDiscoveryView.this.logError(Messages.EndpointDiscoveryView_ERROR_MSG_RSA_IMPORTSERVICE_FAILED, exception);
                            EndpointDiscoveryView.this.showMessage(String.valueOf(Messages.EndpointDiscoveryView_ERROR_MSG_RSA_IMPORTSERVICE_FAILED_PREFIX) + exception.getMessage() + Messages.EndpointDiscoveryView_ERROR_MSG_SUFFIX);
                        } else {
                            edNode.setImportReg(new ImportRegistrationNode(reg));
                            EndpointDiscoveryView.this.viewer.refresh();
                        }
                    }
                }
            }
        };
        this.importAction.setText(Messages.EndpointDiscoveryView_IMPORT_REMOTE_SERVICE);
        this.importAction.setToolTipText(Messages.EndpointDiscoveryView_IMPORT_REMOTE_SERVICE_TT);
        this.importAction.setImageDescriptor(RSAImageRegistry.DESC_RSPROXY_CO);
        this.unimportAction = new Action(){

            public void run() {
                EndpointNode edNode = EndpointDiscoveryView.this.getEDNodeSelected();
                if (edNode != null) {
                    RemoteServiceAdmin.ImportRegistration ir = edNode.getImportRegistration();
                    if (ir == null) {
                        return;
                    }
                    try {
                        ir.close();
                        edNode.setImportReg(null);
                        EndpointDiscoveryView.this.viewer.refresh();
                    }
                    catch (Exception e) {
                        EndpointDiscoveryView.this.logError(Messages.EndpointDiscoveryView_ERROR_MSG_CANNOT_CLOSE_IR, e);
                        EndpointDiscoveryView.this.showMessage(String.valueOf(Messages.EndpointDiscoveryView_ERROR_MSG_CANNOT_CLOSE_IR_PREFIX) + e.getMessage() + Messages.EndpointDiscoveryView_ERROR_MSG_SUFFIX);
                    }
                }
            }
        };
        this.unimportAction.setText(Messages.EndpointDiscoveryView_CLOSE_IMPORTED_REMOTE_SERVICE);
        this.unimportAction.setToolTipText(Messages.EndpointDiscoveryView_CLOSE_IMPORTED_REMOTE_SERVICE_TT);
        this.edefDiscoverAction = new Action(){

            public void run() {
                IEndpointDescriptionLocator locator = EndpointDiscoveryView.this.discovery.getEndpointDescriptionLocator();
                if (locator != null) {
                    FileDialog dialog = new FileDialog(EndpointDiscoveryView.this.viewer.getControl().getShell(), 4096);
                    dialog.setFilterExtensions(new String[]{"*.xml"});
                    dialog.setText(Messages.EndpointDiscoveryView_OPEN_EDEF_FILE);
                    dialog.setFilterPath(null);
                    String result = dialog.open();
                    if (result != null) {
                        try {
                            EndpointDescription[] eds = (EndpointDescription[])new EndpointDescriptionReader().readEndpointDescriptions((InputStream)new FileInputStream(result));
                            if (eds != null) {
                                int i = 0;
                                while (i < eds.length) {
                                    locator.discoverEndpoint(eds[i]);
                                    ++i;
                                }
                            }
                        }
                        catch (IOException e) {
                            EndpointDiscoveryView.this.logError(Messages.EndpointDiscoveryView_ERROR_MSG_ENDPOINT_PARSING_FAILED, e);
                            EndpointDiscoveryView.this.showMessage(String.valueOf(Messages.EndpointDiscoveryView_ERROR_MSG_ENDPOINT_PARSING_FAILED_PREFIX) + e.getMessage() + Messages.EndpointDiscoveryView_ERROR_MSG_SUFFIX);
                        }
                    }
                }
            }
        };
        this.edefDiscoverAction.setText(Messages.EndpointDiscoveryView_OPEN_EDEF_FILE_DIALOG);
        this.edefDiscoverAction.setToolTipText(Messages.EndpointDiscoveryView_OPEN_EDEF_FILE_DIALOG_TT);
        this.edefDiscoverAction.setEnabled(this.discovery.getRSA() != null);
        this.edefDiscoverAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.undiscoverAction = new Action(){

            public void run() {
                IEndpointDescriptionLocator l;
                EndpointNode endpoint = EndpointDiscoveryView.this.getEDNodeSelected();
                if (endpoint != null && endpoint.getImportRegistration() == null && (l = EndpointDiscoveryView.this.discovery.getEndpointDescriptionLocator()) != null && MessageDialog.openQuestion((Shell)EndpointDiscoveryView.this.viewer.getControl().getShell(), (String)Messages.EndpointDiscoveryView_REMOVE_ENDPOINT_QUESTION_TITLE, (String)Messages.EndpointDiscoveryView_REMOVE_ENDPOINT_QUESTION)) {
                    l.undiscoverEndpoint(endpoint.getEndpointDescription());
                }
            }
        };
        this.undiscoverAction.setText(Messages.EndpointDiscoveryView_REMOVE_ENDPOINT);
        this.undiscoverAction.setToolTipText(Messages.EndpointDiscoveryView_REMOVE_ENDPOINT_TT);
    }

    EndpointNode getEDNodeSelected() {
        AbstractEndpointNode aen = this.getNodeSelected();
        return aen instanceof EndpointNode ? (EndpointNode)aen : null;
    }

    boolean isRootSelected() {
        return this.contentProvider.getRootNode().equals(this.getNodeSelected());
    }

    AbstractEndpointNode getNodeSelected() {
        return (AbstractEndpointNode)((ITreeSelection)this.viewer.getSelection()).getFirstElement();
    }

    void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.EndpointDiscoveryView_ENDPOINT_MSGBOX_TITLE, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void handleEndpointChanged(final EndpointEvent event) {
        if (this.viewer == null) {
            return;
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EndpointDescription ed = (EndpointDescription)event.getEndpoint();
                int type = event.getType();
                switch (type) {
                    case 1: {
                        EndpointDiscoveryView.this.addEndpoint(ed);
                        break;
                    }
                    case 2: {
                        EndpointDiscoveryView.this.removeEndpoint(ed);
                    }
                }
                EndpointDiscoveryView.this.viewer.setExpandedState((Object)EndpointDiscoveryView.this.contentProvider.getRootNode(), true);
                EndpointDiscoveryView.this.viewer.refresh();
            }
        });
    }

    void addEndpoint(EndpointDescription ed) {
        if (this.previousRegistryBrowserGroupBy != 2) {
            this.showServicesInRegistryBrowser();
        }
        this.contentProvider.getRootNode().addChild(this.createEndpointDescriptionNode(ed));
    }

    void removeEndpoint(EndpointDescription ed) {
        this.contentProvider.getRootNode().removeChild(new EndpointNode(ed));
    }

    RemoteServiceAdmin.ImportRegistration findImportRegistration(EndpointDescription ed) {
        RemoteServiceAdmin rsa = this.discovery.getRSA();
        if (rsa == null) {
            return null;
        }
        List iRegs = rsa.getImportedRegistrations();
        for (RemoteServiceAdmin.ImportRegistration ir : iRegs) {
            RemoteServiceAdmin.ImportReference importRef = (RemoteServiceAdmin.ImportReference)ir.getImportReference();
            if (importRef == null || !ed.equals((Object)importRef.getImportedEndpoint())) continue;
            return ir;
        }
        return null;
    }

    EndpointNode createEndpointDescriptionNode(EndpointDescription ed) {
        IServiceID serviceID;
        EndpointNode edo = new EndpointNode(ed, new ImportRegistrationNode(this.findImportRegistration(ed)));
        EndpointInterfacesNode ein = new EndpointInterfacesNode();
        for (String intf : ed.getInterfaces()) {
            ein.addChild(new EndpointPackageVersionNode(EndpointNode.getPackageName(intf)));
        }
        edo.addChild(ein);
        List aintfs = ed.getAsyncInterfaces();
        if (aintfs.size() > 0) {
            EndpointAsyncInterfacesNode ain = new EndpointAsyncInterfacesNode();
            for (String intf : ed.getAsyncInterfaces()) {
                ain.addChild(new EndpointPackageVersionNode(EndpointNode.getPackageName(intf)));
            }
            edo.addChild(ain);
        }
        edo.addChild(new EndpointIDNode());
        EndpointHostGroupNode idp = new EndpointHostGroupNode(Messages.EndpointDiscoveryView_REMOTE_HOST_NAME);
        idp.addChild(new EndpointNamespaceNode());
        idp.addChild(new EndpointRemoteServiceIDNode());
        ID connectTarget = ed.getConnectTargetID();
        if (connectTarget != null) {
            idp.addChild(new EndpointConnectTargetIDNode());
        }
        idp.addChild(new EndpointServiceIDNode());
        idp.addChild(new EndpointIntentsNode());
        idp.addChild(new EndpointConfigTypesNode());
        idp.addChild(new EndpointFrameworkIDNode());
        idp.addChild(new EndpointTimestampNode());
        String filter = ed.getRemoteServiceFilter();
        if (filter != null) {
            idp.addChild(new EndpointRemoteServiceFilterNode());
        }
        edo.addChild(idp);
        IEndpointDescriptionLocator locator = this.discovery.getEndpointDescriptionLocator();
        IServiceID iServiceID = serviceID = locator == null ? null : locator.getNetworkDiscoveredServiceID(ed);
        if (serviceID != null) {
            edo.addChild(new EndpointDiscoveryGroupNode(Messages.EndpointDiscoveryView_DISCOVERY_GROUP_NAME, serviceID));
        }
        return edo;
    }
}

