/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

public class DNSOutput {
    private byte[] array;
    private int pos;
    private int savedPos;

    public DNSOutput(int size) {
        this.array = new byte[size];
        this.pos = 0;
        this.savedPos = -1;
    }

    public DNSOutput() {
        this(32);
    }

    public int current() {
        return this.pos;
    }

    private void check(long val, int bits) {
        long max = 1L;
        if (val < 0L || val > (max <<= bits)) {
            throw new IllegalArgumentException(val + " out of range for " + bits + " bit value");
        }
    }

    private void need(int n) {
        if (this.array.length - this.pos >= n) {
            return;
        }
        int newsize = this.array.length * 2;
        if (newsize < this.pos + n) {
            newsize = this.pos + n;
        }
        byte[] newarray = new byte[newsize];
        System.arraycopy(this.array, 0, newarray, 0, this.pos);
        this.array = newarray;
    }

    public void jump(int index) {
        if (index > this.pos) {
            throw new IllegalArgumentException("cannot jump past end of data");
        }
        this.pos = index;
    }

    public void save() {
        this.savedPos = this.pos;
    }

    public void restore() {
        if (this.savedPos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.savedPos;
        this.savedPos = -1;
    }

    public void writeU8(int val) {
        this.check(val, 8);
        this.need(1);
        this.array[this.pos++] = (byte)(val & 0xFF);
    }

    public void writeU16(int val) {
        this.check(val, 16);
        this.need(2);
        this.array[this.pos++] = (byte)(val >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(val & 0xFF);
    }

    public void writeU16At(int val, int where) {
        this.check(val, 16);
        if (where > this.pos - 2) {
            throw new IllegalArgumentException("cannot write past end of data");
        }
        this.array[where++] = (byte)(val >>> 8 & 0xFF);
        this.array[where] = (byte)(val & 0xFF);
    }

    public void writeU32(long val) {
        this.check(val, 32);
        this.need(4);
        this.array[this.pos++] = (byte)(val >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(val >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(val >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(val & 0xFFL);
    }

    public void writeByteArray(byte[] b, int off, int len) {
        this.need(len);
        System.arraycopy(b, off, this.array, this.pos, len);
        this.pos += len;
    }

    public void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b.length);
    }

    public void writeCountedString(byte[] s) {
        if (s.length > 255) {
            throw new IllegalArgumentException("Invalid counted string");
        }
        this.need(1 + s.length);
        this.array[this.pos++] = (byte)(s.length & 0xFF);
        this.writeByteArray(s, 0, s.length);
    }

    public byte[] toByteArray() {
        byte[] out = new byte[this.pos];
        System.arraycopy(this.array, 0, out, 0, this.pos);
        return out;
    }

    static byte[] toU16(int val) {
        return new byte[]{(byte)(val >>> 8 & 0xFF), (byte)(val & 0xFF)};
    }
}

