/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.jms.container.AbstractJMSContainerInstantiator;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMqttContainerInstantiator
extends AbstractJMSContainerInstantiator {
    public static final String[] mqttIntents = new String[]{"MQTT"};
    public static final String CO_P = "mqttconnectoptions";
    public static final String CLEANSESSION_P = "cleansession";
    public static final String CONNECTIONTIMEOUT_P = "connectiontimeout";
    public static final String KEEPALIVEINTERVAL_P = "keepaliveinterval";
    public static final String MAXINFLIGHT_P = "maxinflight";
    public static final String USERNAME_P = "username";
    public static final String PASSWORD_P = "password";
    public static final String SOCKETFACTORY_P = "socketfactory";
    public static final String SSLPROPERTIES_P = "sslproperties";
    public static final String CLIENTQOS_P = "clientqos";

    public AbstractMqttContainerInstantiator(String exporter, String importer) {
        super(exporter, importer);
    }

    public AbstractMqttContainerInstantiator(List<String> exporterConfigs, Map<String, List<String>> exporterConfigToImporterConfig) {
        super(exporterConfigs, exporterConfigToImporterConfig);
    }

    public AbstractMqttContainerInstantiator(String exporter, List<String> importers) {
        super(exporter, importers);
    }

    protected abstract IContainer createMqttContainer(JMSContainerConfig var1, MqttConnectOptions var2, int var3, Map<String, ?> var4) throws Exception;

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        String id = null;
        if (parameters != null) {
            if (parameters[0] instanceof Map) {
                return this.createInstance(description, (Map)parameters[0]);
            }
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i] instanceof String) {
                    id = (String)parameters[i];
                } else if (parameters[i] instanceof ID) {
                    id = ((ID)parameters[i]).getName();
                }
                ++i;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (id != null) {
            params.put("id", id);
        }
        return super.createInstance(description, new Object[]{params});
    }

    protected abstract JMSID createContainerID(Map<String, ?> var1) throws Exception;

    private <T> T getMqttParameterValue(Map<String, ?> parameters, String param, Class<T> clazz, T def) {
        Object result = this.getParameterValue(parameters, param, clazz, def);
        if (result != null) {
            return (T)result;
        }
        return (T)this.getParameterValue(parameters, "." + param, clazz, def);
    }

    public IContainer createInstance(ContainerTypeDescription description, Map<String, ?> parameters) throws ContainerCreateException {
        try {
            Properties properties;
            SocketFactory socketFactory;
            String password;
            String username;
            Integer mif;
            Integer ka;
            MqttConnectOptions options = this.getMqttParameterValue(parameters, CO_P, MqttConnectOptions.class, new MqttConnectOptions());
            Boolean b = this.getMqttParameterValue(parameters, CLEANSESSION_P, Boolean.class, Boolean.TRUE);
            options.setCleanSession(b.booleanValue());
            Integer ct = this.getMqttParameterValue(parameters, CONNECTIONTIMEOUT_P, Integer.class, null);
            if (ct != null) {
                options.setKeepAliveInterval(ct.intValue());
            }
            if ((ka = (Integer)this.getMqttParameterValue(parameters, KEEPALIVEINTERVAL_P, Integer.class, null)) != null) {
                options.setKeepAliveInterval(ka.intValue());
            }
            if ((mif = (Integer)this.getMqttParameterValue(parameters, MAXINFLIGHT_P, Integer.class, null)) != null) {
                options.setMaxInflight(mif.intValue());
            }
            if ((username = (String)this.getMqttParameterValue(parameters, USERNAME_P, String.class, null)) != null && (password = (String)this.getMqttParameterValue(parameters, PASSWORD_P, String.class, null)) != null) {
                options.setUserName(username);
                options.setPassword(password.toCharArray());
            }
            if ((socketFactory = (SocketFactory)this.getMqttParameterValue(parameters, SOCKETFACTORY_P, SocketFactory.class, null)) != null) {
                options.setSocketFactory(socketFactory);
            }
            if ((properties = (Properties)this.getMqttParameterValue(parameters, SSLPROPERTIES_P, Properties.class, null)) != null) {
                options.setSSLProperties(properties);
            }
            Integer clientqos = this.getMqttParameterValue(parameters, MAXINFLIGHT_P, Integer.class, 1);
            return this.createMqttContainer(new JMSContainerConfig(this.createContainerID(parameters), this.getKeepAlive(parameters, new Integer(30000)).intValue()), options, clientqos, parameters);
        }
        catch (Exception e) {
            return this.throwCreateException("Could not create mqtt container", e);
        }
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        ArrayList<String> results = new ArrayList<String>();
        String[] genericIntents = super.getSupportedIntents(description);
        int i = 0;
        while (i < genericIntents.length) {
            results.add(genericIntents[i]);
            ++i;
        }
        i = 0;
        while (i < mqttIntents.length) {
            results.add(mqttIntents[i]);
            ++i;
        }
        return results.toArray(new String[0]);
    }
}

