/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ComponentBuilder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class TabbedPropertiesPage
extends AbstractPropertiesPage {
    JTabbedPane tabbedPane;
    private List componentTabWeightHolders;
    private List dynamicTabHandlers;
    private Component previouslySelectedComponent;
    protected static final int DEFAULT_WEIGHT = 0;

    protected TabbedPropertiesPage(WorkbenchContext context) {
        super(context);
    }

    protected TabbedPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initializeLayout() {
        this.add(this.buildTitlePanel(), "First");
        this.tabbedPane = this.buildTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.initializeTabs();
    }

    protected JTabbedPane buildTabbedPane() {
        JTabbedPane result = new JTabbedPane(1, 1);
        result.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        return result;
    }

    protected abstract void initializeTabs();

    protected int tabCount() {
        return this.tabbedPane.getTabCount();
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.componentTabWeightHolders = new ArrayList();
        this.dynamicTabHandlers = new ArrayList();
    }

    protected void addTab(Component component, int tabWeight, String tabTitleKey) {
        this.addTab(this.buildDefaultComponentBuilder(component), tabWeight, tabTitleKey);
    }

    protected void addTab(Component component, String tabTitleKey) {
        this.addTab(component, 0, tabTitleKey);
    }

    protected void addTabAndSelect(Component component, int tabWeight, String tabTitleKey) {
        this.addTab(component, tabWeight, tabTitleKey);
        this.tabbedPane.setSelectedComponent(component);
    }

    protected void addTabAndSelect(Component component, String tabTitleKey) {
        this.addTabAndSelect(component, 0, tabTitleKey);
    }

    protected void addTab(ValueModel enabledValueModel, int tabWeight, ComponentBuilder pageBuilder, String tabTitleKey) {
        DynamicTabHandler handler = new DynamicTabHandler(pageBuilder, tabWeight, tabTitleKey, enabledValueModel);
        handler.engage();
        handler.nodeSet(this.getNode());
        this.dynamicTabHandlers.add(handler);
    }

    protected void addTab(ValueModel enabledValueModel, int tabWeight, Component component, String tabTitleKey) {
        this.addTab(enabledValueModel, tabWeight, this.buildDefaultComponentBuilder(component), tabTitleKey);
    }

    protected void addTab(ComponentBuilder pageBuilder, int tabWeight, String tabTitleKey) {
        Component component = pageBuilder.buildComponent(this.getNode());
        this.insertTab(component, tabWeight, tabTitleKey);
    }

    protected void setSelectedTab(Component component) {
        this.tabbedPane.setSelectedComponent(component);
    }

    protected void destroyTab(Component component) {
        this.removeTab(component);
        if (component == null) {
            return;
        }
        for (DynamicTabHandler handler : this.dynamicTabHandlers) {
            if (handler.getComponent() != component) continue;
            handler.disengage();
            this.dynamicTabHandlers.remove(handler);
            return;
        }
    }

    public void setNode(ApplicationNode node, WorkbenchContext context) {
        if (node == null) {
            this.previouslySelectedComponent = this.tabbedPane.getSelectedComponent();
        }
        super.setNode(node, context);
        for (DynamicTabHandler handler : this.dynamicTabHandlers) {
            handler.nodeSet(node);
        }
        if (node != null) {
            if (CollectionTools.contains((Object[])this.tabbedPane.getComponents(), (Object)this.previouslySelectedComponent)) {
                this.setSelectedTab(this.previouslySelectedComponent);
            } else {
                this.setSelectedTab(this.tabbedPane.getComponentAt(0));
            }
        }
    }

    void insertTab(Component component, int pageWeight, String tabTitleKey) {
        ComponentTabWeightHolder tabWeightHolder = new ComponentTabWeightHolder(component, pageWeight);
        int pageIndex = this.insertTabWeightHolder(tabWeightHolder);
        this.tabbedPane.insertTab(this.resourceRepository().getString(tabTitleKey), null, component, null, pageIndex);
    }

    private int insertTabWeightHolder(ComponentTabWeightHolder tabWeightHolder) {
        int insertionIndex = this.componentTabWeightHolders.size();
        for (int i = 0; i < this.componentTabWeightHolders.size(); ++i) {
            ComponentTabWeightHolder currentHolder = (ComponentTabWeightHolder)this.componentTabWeightHolders.get(i);
            if (currentHolder.getPageWeight() <= tabWeightHolder.getPageWeight()) continue;
            insertionIndex = i;
            break;
        }
        this.componentTabWeightHolders.add(insertionIndex, tabWeightHolder);
        return insertionIndex;
    }

    void removeTab(Component component) {
        this.tabbedPane.remove(component);
        this.removeTabWeightHolderFor(component);
    }

    private void removeTabWeightHolderFor(Component component) {
        ComponentTabWeightHolder holderToRemove = null;
        for (ComponentTabWeightHolder holder : this.componentTabWeightHolders) {
            if (holder.getComponent() != component) continue;
            holderToRemove = holder;
            break;
        }
        if (holderToRemove == null) {
            throw new RuntimeException("DEBUG: Could not find the correct holder for tab.");
        }
        this.componentTabWeightHolders.remove(holderToRemove);
    }

    private ComponentBuilder buildDefaultComponentBuilder(Component component) {
        return new DefaultComponentBuilder(component);
    }

    private class DynamicTabNodeHolder
    extends PropertyValueModelWrapper {
        private ValueModel enabledStateModel;
        protected PropertyChangeListener enabledStateChangeListener;

        private DynamicTabNodeHolder(PropertyValueModel nodeHolder, ValueModel enabledStateModel) {
            super(nodeHolder);
            this.enabledStateModel = enabledStateModel;
        }

        protected void initialize() {
            super.initialize();
            this.enabledStateChangeListener = this.buildEnabledStateChangeListener();
        }

        protected PropertyChangeListener buildEnabledStateChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    DynamicTabNodeHolder.this.enabledStateModelChanged(e);
                }
            };
        }

        public Object getValue() {
            return this.enabledStateModelValue() ? this.valueHolder.getValue() : null;
        }

        public void setValue(Object value) {
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.enabledStateModel.addPropertyChangeListener("value", this.enabledStateChangeListener);
        }

        protected void disengageValueHolder() {
            this.enabledStateModel.removePropertyChangeListener("value", this.enabledStateChangeListener);
            super.disengageValueHolder();
        }

        protected void valueChanged(PropertyChangeEvent e) {
            if (this.enabledStateModelValue()) {
                this.firePropertyChanged("value", e.getOldValue(), e.getNewValue());
            }
        }

        protected void enabledStateModelChanged(PropertyChangeEvent e) {
            if (this.enabledStateModelValue()) {
                this.firePropertyChanged("value", null, this.valueHolder.getValue());
            } else {
                this.firePropertyChanged("value", this.valueHolder.getValue(), null);
            }
        }

        private boolean enabledStateModelValue() {
            return (Boolean)this.enabledStateModel.getValue();
        }
    }

    private class DefaultComponentBuilder
    implements ComponentBuilder {
        private Component component;

        private DefaultComponentBuilder(Component component) {
            this.component = component;
        }

        public Component buildComponent(PropertyValueModel nodeHolder) {
            return this.component;
        }
    }

    private class ComponentTabWeightHolder {
        private Component component;
        private int pageWeight;

        private ComponentTabWeightHolder(Component component, int pageWeight) {
            this.pageWeight = pageWeight;
            this.component = component;
        }

        int getPageWeight() {
            return this.pageWeight;
        }

        Component getComponent() {
            return this.component;
        }
    }

    private class DynamicTabHandler
    implements PropertyChangeListener {
        private Component component;
        private String tabTitleKey;
        private int tabWeight;
        private ComponentBuilder componentBuilder;
        private boolean hasTabBeenAdded;
        private ValueModel enabledStateModel;

        private DynamicTabHandler(ComponentBuilder componentBuilder, int tabWeight, String tabTitleKey, ValueModel enabledStateModel) {
            this.componentBuilder = componentBuilder;
            this.tabTitleKey = tabTitleKey;
            this.tabWeight = tabWeight;
            this.enabledStateModel = enabledStateModel;
        }

        protected void engage() {
            this.enabledStateModel.addPropertyChangeListener("value", this);
        }

        protected void disengage() {
            this.enabledStateModel.removePropertyChangeListener("value", this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            Boolean properyEnabled = (Boolean)event.getNewValue();
            if (properyEnabled.booleanValue()) {
                this.addPropertiesPage();
            } else {
                this.removePropertiesPage();
            }
        }

        protected void nodeSet(ApplicationNode applicationNode) {
            if (applicationNode != null) {
                boolean isPropertyEnabled = (Boolean)this.enabledStateModel.getValue();
                if (isPropertyEnabled && !this.hasTabBeenAdded) {
                    this.addPropertiesPage();
                } else if (!isPropertyEnabled && this.hasTabBeenAdded) {
                    this.removePropertiesPage();
                }
            }
        }

        private void addPropertiesPage() {
            this.component = this.buildComponent();
            TabbedPropertiesPage.this.insertTab(this.component, this.tabWeight, this.tabTitleKey);
            TabbedPropertiesPage.this.setSelectedTab(this.component);
            this.hasTabBeenAdded = true;
        }

        private void removePropertiesPage() {
            int componentIndex = TabbedPropertiesPage.this.tabbedPane.indexOfComponent(this.component);
            int selectedIndex = TabbedPropertiesPage.this.tabbedPane.getSelectedIndex();
            TabbedPropertiesPage.this.removeTab(this.component);
            if (componentIndex < selectedIndex) {
                TabbedPropertiesPage.this.tabbedPane.setSelectedIndex(selectedIndex - 1);
            }
            this.component = null;
            this.hasTabBeenAdded = false;
        }

        private Component buildComponent() {
            DynamicTabNodeHolder holder = new DynamicTabNodeHolder(TabbedPropertiesPage.this.getNodeHolder(), this.enabledStateModel);
            return this.componentBuilder.buildComponent(holder);
        }

        protected Component getComponent() {
            return this.component;
        }
    }
}

