/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Cursor;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProjectCreationDialog;

final class NewProjectAction
extends AbstractFrameworkAction {
    private MappingsPlugin plugin;

    NewProjectAction(MappingsPlugin plugin, WorkbenchContext context) {
        super(context);
        this.plugin = plugin;
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("NEW_PROJECT_ACTION");
        this.initializeAccelerator("NEW_PROJECT_ACTION.accelerator");
        this.initializeIcon("PROJECT.NEW");
        this.initializeToolTipText("NEW_PROJECT_ACTION.toolTipText");
    }

    protected void execute() {
        ProjectCreationDialog dialog = new ProjectCreationDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        this.currentWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.navigatorSelectionModel().pushExpansionState();
        ApplicationNode node = this.plugin.buildProjectNode(dialog.getProject(), this.getWorkbenchContext());
        this.nodeManager().addProjectNode(node);
        this.navigatorSelectionModel().setSelectedNode(node);
        this.navigatorSelectionModel().expandNode(node);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
    }
}

