/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;

public final class RemoveAction
extends AbstractFrameworkAction {
    public RemoveAction(WorkbenchContext context) {
        this(context, "remove");
    }

    public RemoveAction(WorkbenchContext context, String iconKey) {
        super(context);
        this.initializeIcon(iconKey);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("REMOVE_ACTION");
        this.initializeToolTipText("REMOVE_ACTION.toolTipText");
    }

    protected void execute() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        if (selectedNodes.length == 1 ? !this.confirmSingleItemRemoval((RemovableNode)((Object)selectedNodes[0])) : !this.confirmMultipleItemRemoval()) {
            return;
        }
        for (int i = 0; i < selectedNodes.length; ++i) {
            ((RemovableNode)((Object)selectedNodes[i])).remove();
        }
    }

    protected boolean confirmSingleItemRemoval(RemovableNode removable) {
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CONFIRM_REMOVE.message", removable.getName()), this.resourceRepository().getString("CONFIRM_REMOVE.title"), 0);
        return option == 0;
    }

    protected boolean confirmMultipleItemRemoval() {
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CONFIRM_MULTIPLE_REMOVE.message"), this.resourceRepository().getString("CONFIRM_REMOVE.title"), 0);
        return option == 0;
    }
}

