/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReadAllQueryOptimizationPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class RelationalReadAllQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane tabbedPane;
    private QueryGeneralPanel queryGeneralPanel;
    private JPanel queryFormatPanel;
    private OrderingAttributesPanel queryOrderingPanel;
    private ReadAllQueryOptimizationPanel queryOptimizationPanel;
    private RelationalQueryOptionsPanel queryOptionsPanel;

    RelationalReadAllQueryPanel(PropertyValueModel queryHolder, ObjectListSelectionModel querySelectionModel, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout(querySelectionModel);
    }

    private Filter buildOrderingChooseableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isValidForReadAllQueryOrderable();
            }
        };
    }

    private Filter buildOrderingTraversableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isTraversableForReadAllQueryOrderable();
            }
        };
    }

    private void initializeLayout(ObjectListSelectionModel querySelectionModel) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.tabbedPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, querySelectionModel, this.getWorkbenchContextHolder());
        this.queryFormatPanel = new QuerySelectionCriteriaPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryOrderingPanel = new OrderingAttributesPanel(this.queryHolder, this.buildOrderingTraversableFilter(), this.buildOrderingChooseableFilter(), this.getWorkbenchContextHolder());
        this.queryOptimizationPanel = new ReadAllQueryOptimizationPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryOptionsPanel = new RelationalQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.tabbedPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("FORMAT_TAB"), this.queryFormatPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("ORDER_TAB"), this.queryOrderingPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("OPTIMIZATION_TAB"), this.queryOptimizationPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), this.queryOptionsPanel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tabbedPane, constraints);
    }

    protected QuickViewPanel.QuickViewItem buildBatchReadAttributeQuickViewItem(MWBatchReadItem queryItem) {
        return new QueryQuickViewItem((MWQueryItem)queryItem){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOptimizationPanel);
                RelationalReadAllQueryPanel.this.queryOptimizationPanel.selectBatchReadItem((MWBatchReadItem)this.getValue());
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildJoinedAttributeQuickViewItem(MWJoinedItem queryItem) {
        return new QueryQuickViewItem((MWQueryItem)queryItem){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOptimizationPanel);
                RelationalReadAllQueryPanel.this.queryOptimizationPanel.selectJoinedItem((MWJoinedItem)this.getValue());
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildOrderingAttributeQuickViewItem(Ordering queryItem) {
        return new QueryQuickViewItem((MWQueryItem)queryItem){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOrderingPanel);
                RelationalReadAllQueryPanel.this.queryOrderingPanel.select((MWQueryItem)this.getValue());
            }
        };
    }

    protected void selectQueryOptimizationTab() {
        this.tabbedPane.setSelectedComponent(this.queryOptimizationPanel);
    }

    protected void selectQueryOrderingTab() {
        this.tabbedPane.setSelectedComponent(this.queryOrderingPanel);
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.tabbedPane;
    }
}

