/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.util.Collection;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.RenameDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RenamePoolAction
extends AbstractEnablableFrameworkAction {
    public RenamePoolAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("RENAME_POOL");
        this.initializeMnemonic("RENAME_POOL");
        this.initializeIcon("RENAME");
        this.initializeToolTipText("RENAME_POOL.TOOL_TIP");
    }

    protected void execute(ApplicationNode selectedNode) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)selectedNode.getValue();
        ServerSessionAdapter session = (ServerSessionAdapter)pool.getParent().getParent();
        SimplePropertyValueModel stringHolder = new SimplePropertyValueModel();
        stringHolder.setValue(pool.getName());
        Collection existingNames = CollectionTools.collection(session.poolNames());
        existingNames.add("ReadConnectionPool");
        RenameDialog dialog = new RenameDialog(this.getWorkbenchContext(), stringHolder, existingNames);
        dialog.show();
        if (dialog.wasConfirmed()) {
            this.navigatorSelectionModel().pushExpansionState();
            pool.setName((String)stringHolder.getValue());
            this.navigatorSelectionModel().popAndRestoreExpansionState();
            ((AbstractApplicationNode)selectedNode.getProjectRoot()).selectDescendantNodeForValue((Node)pool, this.navigatorSelectionModel());
        }
    }

    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)selectedNode.getValue();
        return !pool.isWriteConnectionPool() && !pool.isReadConnectionPool() && !pool.isSequenceConnectionPool();
    }
}

