/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.ClasspathPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.SessionsListPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ProjectDisplayableTranslatorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class ProjectPropertiesPage
extends TitledPropertiesPage {
    public ProjectPropertiesPage(WorkbenchContext context) {
        super(context);
    }

    private ActionListener buildChangeLocationAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectNode node = (ProjectNode)ProjectPropertiesPage.this.getNode();
                node.saveAs(null, ProjectPropertiesPage.this.getWorkbenchContext());
            }
        };
    }

    private PropertyValueModel buildClasspathHolder() {
        return new TransformationPropertyValueModel(this.getSelectionHolder()){

            protected Object transform(Object value) {
                SCAdapter adapter = (SCAdapter)((Object)value);
                return value == null ? null : adapter.getClassRepository();
            }
        };
    }

    private ListValueModel buildClasspathListAdapter() {
        return new ClasspathListAdapter();
    }

    protected TopLinkSessionsAdapter getProject() {
        return (TopLinkSessionsAdapter)this.getSelectionHolder().getValue();
    }

    private ClasspathPanel.DefaultClasspathDirectoryHolder buildCurrentDirectoryHolder() {
        return new ClasspathPanel.DefaultClasspathDirectoryHolder(){

            public File getDefaultClasspathDirectory() {
                File projectSaveLocation = ProjectPropertiesPage.this.getProject().getSaveDirectory();
                if (projectSaveLocation != null) {
                    return projectSaveLocation;
                }
                String savedLocation = ProjectPropertiesPage.this.preferences().get("recent classpath directory", null);
                if (savedLocation != null) {
                    return new File(savedLocation);
                }
                return FileTools.userHomeDirectory();
            }

            public void setDefaultClasspathDirectory(File defaultClasspathDirectory) {
                File projectSaveLocation = ProjectPropertiesPage.this.getProject().getSaveDirectory();
                if (defaultClasspathDirectory.equals(FileTools.userHomeDirectory())) {
                    defaultClasspathDirectory = null;
                } else if (projectSaveLocation != null && projectSaveLocation.equals(defaultClasspathDirectory)) {
                    defaultClasspathDirectory = null;
                }
                if (defaultClasspathDirectory != null) {
                    ProjectPropertiesPage.this.preferences().put("recent classpath directory", defaultClasspathDirectory.getPath());
                } else {
                    ProjectPropertiesPage.this.preferences().remove("recent classpath directory");
                }
            }
        };
    }

    protected DisplayableAdapter buildDisplayableAdapter() {
        return new ProjectDisplayableTranslatorAdapter(this.resourceRepository());
    }

    private Document buildLocationDocumentAdapter() {
        TransformationPropertyValueModel transformation = new TransformationPropertyValueModel(this.buildLocationHolder()){

            protected Object transform(Object value) {
                File file = (File)value;
                if (file == null) {
                    return null;
                }
                File location = file.getParentFile();
                if (location == null) {
                    return null;
                }
                return FileTools.canonicalFile((File)location).getPath();
            }
        };
        return new DocumentAdapter(transformation);
    }

    private PropertyValueModel buildLocationHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "configSavePath"){

            protected Object getValueFromSubject() {
                TopLinkSessionsAdapter adapter = (TopLinkSessionsAdapter)this.subject;
                return adapter.getPath();
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        Insets borderInsets = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel projectSaveLocationLabel = this.buildLabel("PROJECT_LOCATION_FIELD");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, borderInsets.left + 5, 0, 0);
        panel.add((Component)projectSaveLocationLabel, constraints);
        this.addHelpTopicId(projectSaveLocationLabel, "scproject.location");
        JTextField locationField = new JTextField(this.buildLocationDocumentAdapter(), null, 1);
        locationField.setEditable(false);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, borderInsets.left + 5, 0, 0);
        panel.add((Component)locationField, constraints);
        this.addHelpTopicId(locationField, "scproject.location");
        projectSaveLocationLabel.setLabelFor(locationField);
        JButton changeLocationButton = this.buildButton("PROJECT_LOCATION_BROWSE_BUTTON");
        changeLocationButton.addActionListener(this.buildChangeLocationAction());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, borderInsets.right + 5);
        panel.add((Component)changeLocationButton, constraints);
        this.addHelpTopicId(changeLocationButton, "scproject.location");
        this.addAlignRight(changeLocationButton);
        ClasspathPanel classpathPanel = new ClasspathPanel(this.getApplicationContext(), this.buildClasspathListAdapter(), this.buildRootFileHolder(), true);
        classpathPanel.setDefaultClasspathDirectoryHolder(this.buildCurrentDirectoryHolder());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)classpathPanel, constraints);
        this.addPaneForAlignment(classpathPanel);
        this.addHelpTopicId(classpathPanel, "scproject.classpath");
        SessionsListPane sessionListPane = new SessionsListPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)sessionListPane, constraints);
        this.addPaneForAlignment(sessionListPane);
        this.addHelpTopicId(sessionListPane, "scproject.sessions");
        this.addHelpTopicId(panel, "scproject");
        return panel;
    }

    private ValueModel buildRootFileHolder() {
        return new SimplePropertyValueModel(this.getSelectionHolder()){

            public Object getValue() {
                ValueModel projectHolder = (ValueModel)super.getValue();
                TopLinkSessionsAdapter sessions = (TopLinkSessionsAdapter)projectHolder.getValue();
                return null;
            }
        };
    }

    private class ClasspathListAdapter
    extends ListAspectAdapter {
        private ClasspathListAdapter() {
            super(ProjectPropertiesPage.this.buildClasspathHolder(), "classpathEntries");
        }

        public void addItem(int index, Object item) {
            ClassRepository classpath = (ClassRepository)this.subject;
            classpath.addClasspathEntry(index, (String)item);
        }

        public Object getItem(int index) {
            ClassRepository classpath = (ClassRepository)this.subject;
            return classpath.getClasspathEntry(index);
        }

        protected ListIterator getValueFromSubject() {
            ClassRepository classpath = (ClassRepository)this.subject;
            return classpath.classpathEntries();
        }

        public Object removeItem(int index) {
            ClassRepository classpath = (ClassRepository)this.subject;
            return classpath.removeClasspathEntry(index);
        }

        public Object replaceItem(int index, Object item) {
            ClassRepository classpath = (ClassRepository)this.subject;
            return classpath.replaceClasspathEntry(index, (String)item);
        }
    }
}

