/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.eclipse.persistence.tools.workbench.utility.io.Pipe;

public class Console {
    private StyledDocument document;
    private AttributeSet outAttributeSet;
    private AttributeSet errAttributeSet;
    private OutputStream outStream;
    private OutputStream errStream;
    private Thread outSynchronizerThread;
    private Thread errSynchronizerThread;
    private JTextPane textPane;
    private JFrame console;

    public static Console buildSystemConsole() {
        Console console = new Console();
        System.setOut(new PrintStream(console.getOutStream(), true));
        System.setErr(new PrintStream(console.getErrStream(), true));
        return console;
    }

    public Console() {
        this.initialize();
    }

    protected void initialize() {
        this.document = this.buildDocument();
        this.outAttributeSet = this.buildOutAttributeSet();
        Pipe outPipe = new Pipe();
        this.outStream = outPipe.getOutputStream();
        this.outSynchronizerThread = this.buildSynchronizerThread(outPipe.getInputStream(), this.outAttributeSet, "out");
        this.outSynchronizerThread.start();
        this.errAttributeSet = this.buildErrAttributeSet();
        Pipe errPipe = new Pipe();
        this.errStream = errPipe.getOutputStream();
        this.errSynchronizerThread = this.buildSynchronizerThread(errPipe.getInputStream(), this.errAttributeSet, "err");
        this.errSynchronizerThread.start();
        this.textPane = this.buildTextPane();
        this.console = this.buildConsole();
    }

    private StyledDocument buildDocument() {
        DefaultStyledDocument result = new DefaultStyledDocument();
        SimpleAttributeSet mas = new SimpleAttributeSet();
        StyleConstants.setTabSet(mas, new TabSet(new TabStop[]{new TabStop(30.0f)}));
        result.setParagraphAttributes(0, 0, mas, false);
        result.addDocumentListener(this.buildDocumentListener());
        return result;
    }

    private DocumentListener buildDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                Console.this.documentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                Console.this.documentChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                Console.this.documentChanged();
            }

            public String toString() {
                return "document listener";
            }
        };
    }

    private AttributeSet buildOutAttributeSet() {
        return this.buildAttributeSet(Color.BLACK);
    }

    private AttributeSet buildErrAttributeSet() {
        return this.buildAttributeSet(Color.RED);
    }

    private AttributeSet buildAttributeSet(Color color) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setForeground(attributes, color);
        StyleConstants.setFontFamily(attributes, "Monospaced");
        StyleConstants.setFontSize(attributes, 12);
        return attributes;
    }

    private Thread buildSynchronizerThread(InputStream inputStream, AttributeSet attributeSet, String name) {
        return new Thread((Runnable)new Synchronizer(inputStream, this.document, attributeSet), "Console Synchronizer: " + name);
    }

    private JTextPane buildTextPane() {
        NonWrappingTextPane result = new NonWrappingTextPane(this.document);
        result.setEditable(false);
        return result;
    }

    private JFrame buildConsole() {
        JFrame window = new JFrame(this.title());
        window.setDefaultCloseOperation(1);
        window.getContentPane().add((Component)this.buildMainPanel(), "Center");
        window.setLocation(300, 300);
        window.setSize(600, 400);
        window.addWindowListener(this.buildWindowListener());
        return window;
    }

    protected String title() {
        return "Console";
    }

    protected JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.buildScrollableTextPane(), "Center");
        mainPanel.add(this.buildControlPanel(), "Last");
        return mainPanel;
    }

    protected Component buildScrollableTextPane() {
        return new JScrollPane(this.textPane);
    }

    protected Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new BorderLayout());
        GridLayout grid = new GridLayout(1, 0);
        grid.setHgap(5);
        JPanel controlPanel2 = new JPanel(grid);
        controlPanel2.add(this.buildCopyButton());
        controlPanel2.add(this.buildClearButton());
        controlPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        controlPanel.add((Component)controlPanel2, "After");
        return controlPanel;
    }

    private Component buildCopyButton() {
        return new JButton(this.buildCopyAction());
    }

    private Action buildCopyAction() {
        AbstractAction action = new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent event) {
                Console.this.copy();
            }
        };
        action.setEnabled(true);
        return action;
    }

    private Component buildClearButton() {
        return new JButton(this.buildClearAction());
    }

    private Action buildClearAction() {
        AbstractAction action = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent event) {
                Console.this.clear();
            }
        };
        action.setEnabled(true);
        return action;
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                Console.this.shutDown();
            }

            public String toString() {
                return "window listener";
            }
        };
    }

    public OutputStream getOutStream() {
        return this.outStream;
    }

    public OutputStream getErrStream() {
        return this.errStream;
    }

    public void open() {
        if (this.outSynchronizerThread == null || this.errSynchronizerThread == null) {
            throw new IllegalStateException("Console cannot be re-opened once it has been closed.");
        }
        this.console.setVisible(true);
    }

    public void hide() {
        this.console.setVisible(false);
    }

    public void close() {
        this.console.dispose();
    }

    void documentChanged() {
        this.textPane.setCaretPosition(this.document.getLength());
        if (!this.console.isVisible()) {
            this.open();
        }
    }

    void copy() {
        this.textPane.selectAll();
        this.textPane.copy();
        this.textPane.setCaretPosition(this.document.getLength());
    }

    public void clear() {
        try {
            this.document.remove(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void shutDown() {
        this.outSynchronizerThread.interrupt();
        this.outSynchronizerThread = null;
        this.errSynchronizerThread.interrupt();
        this.errSynchronizerThread = null;
    }

    private static class NonWrappingTextPane
    extends JTextPane {
        NonWrappingTextPane(StyledDocument document) {
            super(document);
        }

        public boolean getScrollableTracksViewportWidth() {
            return this.getSize().width < this.getParent().getSize().width;
        }

        public void setSize(Dimension d) {
            if (d.width < this.getParent().getSize().width) {
                d.width = this.getParent().getSize().width;
            }
            super.setSize(d);
        }
    }

    private static class Appendix
    implements Runnable {
        private Document document;
        private String string;
        private AttributeSet attributeSet;

        Appendix(Document document, String string, AttributeSet attributeSet) {
            this.document = document;
            this.string = string;
            this.attributeSet = attributeSet;
        }

        public void run() {
            try {
                this.document.insertString(this.document.getLength(), this.string, this.attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class Synchronizer
    implements Runnable {
        private InputStream inputStream;
        private Document document;
        private AttributeSet attributeSet;

        Synchronizer(InputStream inputStream, Document document, AttributeSet attributeSet) {
            this.inputStream = inputStream;
            this.document = document;
            this.attributeSet = attributeSet;
        }

        public void run() {
            byte[] buffer = new byte[2048];
            int length = this.read(buffer);
            while (length != -1) {
                this.appendDocument(new String(buffer, 0, length));
                length = this.read(buffer);
            }
        }

        private int read(byte[] buffer) {
            try {
                return this.inputStream.read(buffer);
            }
            catch (InterruptedIOException ex) {
                return -1;
            }
            catch (IOException ex) {
                this.appendDocument("The Thread writing to the pipe is dead.");
                return 0;
            }
        }

        private void appendDocument(String string) {
            EventQueue.invokeLater(new Appendix(this.document, string, this.attributeSet));
        }
    }
}

