/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.string.SimpleStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringMatcher;

public class FilteringListPanel
extends JPanel {
    private Object[] completeList;
    StringConverter stringConverter;
    private JTextField textField;
    private JLabel textFieldLabel;
    private DocumentListener textFieldListener;
    private JList listBox;
    private JLabel listBoxLabel;
    private int maxListSize;
    private StringMatcher stringMatcher;
    private Object[] buffer;
    private static final Border TEXT_FIELD_LABEL_BORDER = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    private static final Border LIST_BOX_LABEL_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);

    public FilteringListPanel(Object[] completeList, Object initialSelection) {
        this(completeList, initialSelection, StringConverter.DEFAULT_INSTANCE);
    }

    public FilteringListPanel(Object[] completeList, Object initialSelection, StringConverter stringConverter) {
        super(new BorderLayout());
        this.completeList = completeList;
        this.stringConverter = stringConverter;
        this.initialize(initialSelection);
    }

    private void initialize(Object initialSelection) {
        this.maxListSize = this.defaultMaxListSize();
        this.buffer = new Object[this.max()];
        this.textFieldListener = this.buildTextFieldListener();
        this.stringMatcher = this.buildStringMatcher();
        this.initializeLayout(initialSelection);
    }

    private int max() {
        if (this.maxListSize == -1) {
            return this.completeList.length;
        }
        return Math.min(this.maxListSize, this.completeList.length);
    }

    private DocumentListener buildTextFieldListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public void changedUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public void removeUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public String toString() {
                return "text field listener";
            }
        };
    }

    private int defaultMaxListSize() {
        return -1;
    }

    private StringMatcher buildStringMatcher() {
        return new SimpleStringMatcher();
    }

    private void initializeLayout(Object initialSelection) {
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        this.textFieldLabel = new JLabel();
        this.textFieldLabel.setBorder(TEXT_FIELD_LABEL_BORDER);
        textFieldPanel.add((Component)this.textFieldLabel, "North");
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(this.textFieldListener);
        this.textFieldLabel.setLabelFor(this.textField);
        textFieldPanel.add((Component)this.textField, "Center");
        this.add((Component)textFieldPanel, "North");
        JPanel listBoxPanel = new JPanel(new BorderLayout());
        this.listBoxLabel = new JLabel();
        this.listBoxLabel.setBorder(LIST_BOX_LABEL_BORDER);
        listBoxPanel.add((Component)this.listBoxLabel, "North");
        this.listBox = new JList();
        this.listBox.setDoubleBuffered(true);
        this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        this.listBox.getSelectionModel().setSelectionMode(0);
        this.listBox.setPrototypeCellValue(this.prototypeCellValue());
        this.listBox.setPrototypeCellValue(null);
        this.listBox.setCellRenderer(this.buildDefaultCellRenderer());
        this.listBoxLabel.setLabelFor(this.listBox);
        JScrollPane listBoxScrollPane = new JScrollPane(this.listBox);
        listBoxScrollPane.getHorizontalScrollBar().setFocusable(false);
        listBoxScrollPane.getVerticalScrollBar().setFocusable(false);
        listBoxPanel.add((Component)listBoxScrollPane, "Center");
        this.listBox.setSelectedValue(initialSelection, true);
        this.textField.select(0, this.textField.getText().length());
        this.add((Component)listBoxPanel, "Center");
    }

    public Object getSelection() {
        return this.listBox.getSelectedValue();
    }

    public void setSelection(Object selection) {
        this.listBox.setSelectedValue(selection, true);
    }

    public Object[] getCompleteList() {
        return this.completeList;
    }

    public void setCompleteList(Object[] completeList) {
        this.completeList = completeList;
        if (this.buffer.length < this.max()) {
            this.buffer = new Object[this.max()];
        }
        this.filterList();
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(int maxListSize) {
        this.maxListSize = maxListSize;
        if (this.buffer.length < this.max()) {
            this.buffer = new Object[this.max()];
        }
        this.filterList();
    }

    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
        this.filterList();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JLabel getTextFieldLabel() {
        return this.textFieldLabel;
    }

    public void setTextFieldLabelText(String text) {
        this.textFieldLabel.setText(text);
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void setListBoxCellRenderer(ListCellRenderer renderer) {
        this.listBox.setCellRenderer(renderer);
    }

    public JLabel getListBoxLabel() {
        return this.listBoxLabel;
    }

    public void setListBoxLabelText(String text) {
        this.listBoxLabel.setText(text);
    }

    public void setComponentsFont(Font font) {
        this.textFieldLabel.setFont(font);
        this.textField.setFont(font);
        this.listBoxLabel.setFont(font);
        this.listBox.setFont(font);
    }

    public StringMatcher getStringMatcher() {
        return this.stringMatcher;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.stringMatcher = stringMatcher;
        this.filterList();
    }

    protected String prototypeCellValue() {
        return "==========> A_STRING_THAT_IS_DEFINITELY_LONGER_THAN_EVERY_STRING_IN_THE_LIST <==========";
    }

    protected ListCellRenderer buildDefaultCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return FilteringListPanel.this.stringConverter.convertToString(value);
            }
        };
    }

    synchronized void filterList() {
        this.filterList(this.textField.getText());
    }

    private void filterList(String pattern) {
        if (pattern.length() == 0) {
            this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        } else {
            this.stringMatcher.setPatternString(pattern);
            int j = 0;
            int len = this.completeList.length;
            int max = this.max();
            for (int i = 0; i < len; ++i) {
                if (this.stringMatcher.matches(this.stringConverter.convertToString(this.completeList[i]))) {
                    this.buffer[j++] = this.completeList[i];
                }
                if (j == max) break;
            }
            this.listBox.setModel(this.buildPartialArrayListModel(this.buffer, j));
        }
        if (this.listBox.getModel().getSize() == 0) {
            this.listBox.getSelectionModel().clearSelection();
        } else {
            this.listBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.listBox.getSelectionModel().setLeadSelectionIndex(0);
            this.listBox.ensureIndexIsVisible(0);
        }
    }

    private ListModel buildPartialArrayListModel(final Object[] array, final int size) {
        return new AbstractListModel(){

            public int getSize() {
                return size;
            }

            public Object getElementAt(int index) {
                return array[index];
            }
        };
    }
}

