/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class ExtendedListValueModelWrapper
extends ListValueModelWrapper {
    protected final List prefix;
    protected final List suffix;

    public ExtendedListValueModelWrapper(List prefix, ListValueModel listHolder, List suffix) {
        super(listHolder);
        this.prefix = new ArrayList(prefix);
        this.suffix = new ArrayList(suffix);
    }

    public ExtendedListValueModelWrapper(Object prefix, ListValueModel listHolder, Object suffix) {
        this(Collections.singletonList(prefix), listHolder, Collections.singletonList(suffix));
    }

    public ExtendedListValueModelWrapper(List prefix, ListValueModel listHolder) {
        this(prefix, listHolder, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(Object prefix, ListValueModel listHolder) {
        this(Collections.singletonList(prefix), listHolder, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder, List suffix) {
        this(Collections.EMPTY_LIST, listHolder, suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder, Object suffix) {
        this(Collections.EMPTY_LIST, listHolder, Collections.singletonList(suffix));
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder) {
        this(Collections.singletonList(null), listHolder, Collections.EMPTY_LIST);
    }

    public Object getValue() {
        return new ReadOnlyListIterator((ListIterator)new CompositeListIterator(this.prefix.listIterator(), (ListIterator)this.listHolder.getValue(), this.suffix.listIterator()));
    }

    public void addItem(int index, Object item) {
        this.addItems(index, Collections.singletonList(item));
    }

    public void addItems(int index, List items) {
        if (items.size() == 0) {
            return;
        }
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (index > prefixSize + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        this.listHolder.addItems(index - prefixSize, items);
    }

    public Object removeItem(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (index >= prefixSize + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.removeItem(index - prefixSize);
    }

    public List removeItems(int index, int length) {
        if (length == 0) {
            return Collections.EMPTY_LIST;
        }
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (index + length > prefixSize + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.removeItems(index - prefixSize, length);
    }

    public Object replaceItem(int index, Object item) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (index >= prefixSize + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.replaceItem(index - prefixSize, item);
    }

    public List replaceItems(int index, List items) {
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (index + items.size() > prefixSize + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.replaceItems(index - prefixSize, items);
    }

    public Object getItem(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listHolder.size()) {
            return this.suffix.get(index - (prefixSize + this.listHolder.size()));
        }
        return this.listHolder.getItem(index - prefixSize);
    }

    public int size() {
        return this.prefix.size() + this.listHolder.size() + this.suffix.size();
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.fireItemsReplaced(e.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void listChanged(ListChangeEvent e) {
        this.fireListChanged("value");
    }

    public void toString(StringBuffer sb) {
        sb.append(this.prefix);
        sb.append(" ");
        super.toString(sb);
        sb.append(" ");
        sb.append(this.suffix);
    }
}

