/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;

public class CheckBoxTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    private JCheckBox checkBox;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public CheckBoxTableCellRenderer() {
        this.initialize();
    }

    public CheckBoxTableCellRenderer(String text, Icon icon) {
        this();
        this.setText(text);
        this.setIcon(icon);
    }

    public CheckBoxTableCellRenderer(String text) {
        this(text, null);
    }

    public CheckBoxTableCellRenderer(Icon icon) {
        this(null, icon);
    }

    protected void initialize() {
        this.checkBox = this.buildCheckBox();
        this.checkBox.setBorderPainted(true);
        this.checkBox.setBorderPaintedFlat(true);
    }

    protected JCheckBox buildCheckBox() {
        JCheckBox cb = new JCheckBox();
        cb.addActionListener(this.buildActionListener());
        return cb;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CheckBoxTableCellRenderer.this.immediateEditListener != null) {
                    CheckBoxTableCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        this.checkBox.setHorizontalAlignment(0);
        this.checkBox.setComponentOrientation(table.getComponentOrientation());
        this.checkBox.setFont(table.getFont());
        this.checkBox.setEnabled(table.isEnabled());
        this.checkBox.setForeground(this.foregroundColor(table, value, selected, hasFocus, row, column));
        this.checkBox.setBackground(this.backgroundColor(table, value, selected, hasFocus, row, column));
        this.checkBox.setOpaque(this.cellIsOpaqueIn(table, value, selected, hasFocus, row, column));
        this.checkBox.setBorder(this.border(table, value, selected, hasFocus, row, column));
        this.setValue(value);
        return this.checkBox;
    }

    protected Color foregroundColor(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return UIManager.getColor("Table.focusCellForeground");
            }
            return table.getSelectionForeground();
        }
        return table.getForeground();
    }

    protected Color backgroundColor(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return UIManager.getColor("Table.focusCellBackground");
            }
            return table.getSelectionBackground();
        }
        return table.getBackground();
    }

    protected Border border(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        return hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER;
    }

    protected boolean cellIsOpaqueIn(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        Color cellBackground = this.checkBox.getBackground();
        Color tableBackground = table.getBackground();
        return !table.isOpaque() || !cellBackground.equals(tableBackground);
    }

    protected void setValue(Object value) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.checkBox.setSelected((Boolean)value);
    }

    public Object getValue() {
        return this.checkBox.isSelected();
    }

    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    public void commit() {
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public void setIcon(Icon icon) {
        this.checkBox.setIcon(icon);
    }

    public int getPreferredHeight() {
        return (int)this.checkBox.getPreferredSize().getHeight() + 2;
    }
}

