/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.eclipse.persistence.tools.workbench.uitools.cell.LabeledTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class ComboBoxTreeCellRenderer
extends LabeledTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;
    protected Color defaultComboBoxForeground;
    protected Color defaultComboBoxBackground;

    public ComboBoxTreeCellRenderer(ComboBoxModel model, String labelText, Icon labelIcon) {
        super(labelText, labelIcon);
        this.setModel(model);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel model, String labelText) {
        super(labelText);
        this.setModel(model);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel model, Icon labelIcon) {
        super(labelIcon);
        this.setModel(model);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel model) {
        this.setModel(model);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel model, String labelText, Icon labelIcon, ListCellRenderer renderer) {
        this(model, labelText, labelIcon);
        this.setRenderer(renderer);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel model, ListCellRenderer renderer) {
        this(model);
        this.setRenderer(renderer);
    }

    protected JComponent buildComponent() {
        JComboBox comboBox = new JComboBox();
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        comboBox.addActionListener(this.buildActionListener());
        this.defaultComboBoxForeground = comboBox.getForeground();
        this.defaultComboBoxBackground = comboBox.getBackground();
        return comboBox;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                Object selectedItem = comboBox.getSelectedItem();
                if (ComboBoxTreeCellRenderer.this.getValue() != selectedItem) {
                    ComboBoxTreeCellRenderer.this.setValue(comboBox.getSelectedItem());
                    ComboBoxTreeCellRenderer.this.immediateEdit();
                }
            }
        };
    }

    void immediateEdit() {
        if (this.immediateEditListener != null) {
            this.immediateEditListener.immediateEdit();
        }
    }

    protected JComboBox getComboBox() {
        return (JComboBox)this.component;
    }

    protected void setForeground(Color c) {
        super.setForeground(c);
        if (c == UIManager.getColor("Tree.textForeground")) {
            this.component.setForeground(this.defaultComboBoxForeground);
        }
    }

    protected void setBackground(Color c) {
        super.setBackground(c);
        if (c == UIManager.getColor("Tree.textBackground")) {
            this.component.setBackground(this.defaultComboBoxBackground);
        }
    }

    protected void setValue(Object value) {
        this.getComboBox().setSelectedItem(value);
    }

    public Object getValue() {
        return this.getComboBox().getSelectedItem();
    }

    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    public void setModel(ComboBoxModel model) {
        this.getComboBox().setModel(model);
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.getComboBox().setRenderer(renderer);
    }

    protected void addActionListener(ActionListener listener) {
        this.getComboBox().addActionListener(listener);
    }
}

