/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;

public abstract class LabeledTreeCellRenderer
implements TreeCellRenderer {
    private JPanel panel;
    private JLabel label;
    protected JComponent component;
    protected boolean editing = false;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public LabeledTreeCellRenderer(String labelText, Icon labelIcon) {
        this.initialize(labelText, labelIcon);
    }

    public LabeledTreeCellRenderer(String labelText) {
        this(labelText, null);
    }

    public LabeledTreeCellRenderer(Icon labelIcon) {
        this(null, labelIcon);
    }

    public LabeledTreeCellRenderer() {
        this(null, null);
    }

    protected void initialize(String labelText, Icon labelIcon) {
        this.panel = this.buildPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.label = this.buildLabel(labelText, labelIcon);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.panel.add((Component)this.label, constraints);
        this.component = this.buildComponent();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.panel.add((Component)this.component, constraints);
    }

    protected JPanel buildPanel(LayoutManager layoutManager) {
        return new JPanel(layoutManager);
    }

    protected JLabel buildLabel(String labelText, Icon labelIcon) {
        return new JLabel(labelText, labelIcon, 10);
    }

    protected abstract JComponent buildComponent();

    protected void setEditing(boolean editing) {
        this.editing = editing;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setFont(tree.getFont());
        this.setEnabled(tree.isEnabled());
        this.setForeground(this.foregroundColor(tree, value, selected, expanded, leaf, row, hasFocus));
        this.setBackground(this.backgroundColor(tree, value, selected, expanded, leaf, row, hasFocus));
        this.panel.setBorder(this.border(tree, value, selected, expanded, leaf, row, hasFocus));
        this.setOpaque(this.cellIsOpaqueIn(tree, value, selected, expanded, leaf, row, hasFocus));
        this.setValue(value);
        return this.panel;
    }

    protected void setComponentOrientation(ComponentOrientation o) {
        this.panel.setComponentOrientation(o);
        this.label.setComponentOrientation(o);
        this.component.setComponentOrientation(o);
    }

    protected void setFont(Font f) {
        this.panel.setFont(f);
        this.label.setFont(f);
        this.component.setFont(f);
    }

    protected void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.component.setEnabled(enabled);
    }

    protected Color foregroundColor(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (this.editing) {
                return UIManager.getColor("Tree.textForeground");
            }
            return UIManager.getColor("Tree.selectionForeground");
        }
        return UIManager.getColor("Tree.textForeground");
    }

    protected Color backgroundColor(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (this.editing) {
                return UIManager.getColor("Tree.textBackground");
            }
            return UIManager.getColor("Tree.selectionBackground");
        }
        return UIManager.getColor("Tree.textBackground");
    }

    protected void setForeground(Color c) {
        this.panel.setForeground(c);
        this.label.setForeground(c);
        this.component.setForeground(c);
    }

    protected void setBackground(Color c) {
        this.panel.setBackground(c);
        this.label.setBackground(c);
        this.component.setBackground(c);
    }

    protected Border border(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (hasFocus) {
            if (this.editing) {
                return UIManager.getBorder("Tree.editorBorder");
            }
            return BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);
        }
        return NO_FOCUS_BORDER;
    }

    protected boolean cellIsOpaqueIn(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Color cellBackground = this.panel.getBackground();
        Color treeBackground = tree.getBackground();
        return !tree.isOpaque() || !cellBackground.equals(treeBackground);
    }

    protected void setOpaque(boolean opaque) {
        this.panel.setOpaque(opaque);
    }

    protected abstract void setValue(Object var1);

    public void setLabelText(String labelText) {
        this.label.setText(labelText);
    }

    public void setLabelIcon(Icon labelIcon) {
        this.label.setIcon(labelIcon);
    }

    public int getPreferredHeight() {
        return (int)this.panel.getPreferredSize().getHeight() + 2;
    }

    public void setPreferredWidth(int width) {
        this.panel.setPreferredSize(new Dimension(width, this.panel.getPreferredSize().height));
    }
}

