/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLFragmentReader
extends DOMReader {
    protected NamespaceResolver nsresolver;
    protected List<NamespaceResolver> nsresolverList = new ArrayList<NamespaceResolver>();
    protected Map<Element, NamespaceResolver> tmpresolverMap;

    public XMLFragmentReader(NamespaceResolver namespaceResolver) {
        if (null != namespaceResolver) {
            this.nsresolverList.add(namespaceResolver);
        }
        this.tmpresolverMap = new HashMap<Element, NamespaceResolver>();
    }

    public void parse(Node node) throws SAXException {
        if (node.getNodeType() == 11) {
            this.handleChildNodes(node.getChildNodes());
        } else {
            super.parse(node);
        }
    }

    protected void reportElementEvents(Element elem) throws SAXException {
        super.reportElementEvents(elem);
        this.cleanupNamespaceResolvers(elem);
    }

    protected void endDocument() throws SAXException {
    }

    protected void startDocument() throws SAXException {
    }

    protected void handleXMLNSPrefixedAttribute(Element elem, Attr attr) {
        String uri = this.resolveNamespacePrefix(elem.getPrefix());
        if (uri == null || !uri.equals(attr.getLocalName())) {
            NamespaceResolver tmpresolver = this.getTempResolver(elem);
            tmpresolver.put(attr.getLocalName(), attr.getValue());
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
        }
    }

    protected void handlePrefixedAttribute(Element elem) throws SAXException {
        String prefix = elem.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String uri = this.resolveNamespacePrefix(prefix);
        if (prefix == "" && uri == null) {
            return;
        }
        if (uri == null || !uri.equals(elem.getNamespaceURI())) {
            NamespaceResolver tmpresolver = this.getTempResolver(elem);
            tmpresolver.put(prefix, elem.getNamespaceURI());
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
            this.getContentHandler().startPrefixMapping(prefix, elem.getNamespaceURI());
        }
    }

    protected void endPrefixMappings(Element elem) throws SAXException {
        NamespaceResolver tmpresolver = this.getTempResolver(elem);
        if (tmpresolver != null) {
            Enumeration prefixes = tmpresolver.getPrefixes();
            while (prefixes.hasMoreElements()) {
                this.getContentHandler().endPrefixMapping((String)prefixes.nextElement());
            }
        }
    }

    protected NamespaceResolver getTempResolver(Element elem) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem);
        if (tmpresolver == null) {
            tmpresolver = new NamespaceResolver();
            this.tmpresolverMap.put(elem, tmpresolver);
        }
        return tmpresolver;
    }

    protected void cleanupNamespaceResolvers(Element elem) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem);
        if (tmpresolver != null) {
            this.tmpresolverMap.remove(elem);
            this.nsresolverList.remove(tmpresolver);
        }
    }

    protected String resolveNamespacePrefix(String prefix) {
        String uri = null;
        if (null == prefix) {
            NamespaceResolver next;
            for (int i = this.nsresolverList.size() - 1; i >= 0 && ((uri = (next = this.nsresolverList.get(i)).getDefaultNamespaceURI()) == null || uri.length() <= 0); --i) {
            }
        } else {
            NamespaceResolver next;
            for (int i = this.nsresolverList.size() - 1; i >= 0 && ((uri = (next = this.nsresolverList.get(i)).resolveNamespacePrefix(prefix)) == null || uri.length() <= 0); --i) {
            }
        }
        return uri;
    }

    protected void processParentNamespaces(Element element) throws SAXException {
    }

    protected void handleXsiTypeAttribute(Attr attr) throws SAXException {
        String prefix;
        String uri;
        String value = attr.getValue();
        int colon = value.indexOf(58);
        if (colon != -1 && (uri = this.resolveNamespacePrefix(prefix = value.substring(0, colon))) == null && (uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(attr.getOwnerElement(), prefix)) != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }
}

