/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOCSUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOUnmappedContentHandler;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOUnmarshalListener
extends SDOCSUnmarshalListener {
    private List<SDOChangeSummary> changeSummaries;

    public SDOUnmarshalListener(HelperContext aContext) {
        super(aContext);
    }

    @Override
    public void beforeUnmarshal(Object target, Object parent) {
        super.beforeUnmarshal(target, parent);
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        SDODataObject targetDataObject;
        try {
            targetDataObject = (SDODataObject)target;
        }
        catch (ClassCastException ccex) {
            SDOChangeSummary sdoChangeSummary = (SDOChangeSummary)target;
            sdoChangeSummary.setRootDataObject((DataObject)parent);
            this.getChangeSummaries().add(sdoChangeSummary);
            return;
        }
        if (targetDataObject.getType().isSequenced()) {
            targetDataObject.getSequence().afterUnmarshal();
        }
        if (parent == null && null != this.changeSummaries) {
            XMLUnmarshaller unmarshaller = null;
            int changeSummariesSize = this.changeSummaries.size();
            for (int i = 0; i < changeSummariesSize; ++i) {
                SDOChangeSummary nextCS = this.changeSummaries.get(i);
                boolean loggingValue = nextCS.isLoggingMapping();
                nextCS.setLogging(true);
                List xpaths = nextCS.getCreatedXPaths();
                int xpathsSize = xpaths.size();
                for (int j = 0; j < xpathsSize; ++j) {
                    String nextXPath = (String)xpaths.get(j);
                    String sdoPath = this.convertXPathToSDOPath(nextXPath);
                    SDODataObject nextCreatedDO = targetDataObject.getDataObject(sdoPath);
                    if (nextCreatedDO == null) {
                        int nextSlash = sdoPath.indexOf(47);
                        sdoPath = nextSlash != -1 ? sdoPath.substring(nextSlash + 1) : "/";
                        nextCreatedDO = targetDataObject.getDataObject(sdoPath);
                    }
                    if (nextCreatedDO == null) {
                        throw SDOException.errorProcessingXPath(nextXPath);
                    }
                    nextCreatedDO._setCreated(true);
                    nextCS.getOldContainers().remove(nextCreatedDO);
                }
                nextCS.setCreatedXPaths(null);
                List modifiedDoms = nextCS.getModifiedDoms();
                int modifiedDomsSize = modifiedDoms.size();
                for (int j = 0; j < modifiedDomsSize; ++j) {
                    Element nextNode = (Element)modifiedDoms.get(j);
                    String refValue = nextNode.getAttributeNS("commonj.sdo", "ref");
                    if (refValue == null || refValue.length() == 0) {
                        throw SDOException.missingRefAttribute();
                    }
                    String sdoPath = this.convertXPathToSDOPath(refValue);
                    SDODataObject nextModifiedDO = targetDataObject.getDataObject(sdoPath);
                    if (nextModifiedDO == null) {
                        int nextSlash = sdoPath.indexOf(47);
                        sdoPath = nextSlash != -1 ? sdoPath.substring(nextSlash + 1) : "/";
                        nextModifiedDO = targetDataObject.getDataObject(sdoPath);
                    }
                    String unsetValue = nextNode.getAttributeNS("commonj.sdo", "unset");
                    List unsetValueList = new ArrayList();
                    if (unsetValue != null && unsetValue.length() > 0) {
                        XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
                        unsetValueList = (List)xmlConversionManager.convertObject(unsetValue, List.class);
                    }
                    if (nextModifiedDO != null) {
                        SDOProperty nextProp;
                        int k;
                        nextModifiedDO._setModified(true);
                        SDOCSUnmarshalListener listener = new SDOCSUnmarshalListener(nextModifiedDO.getType().getHelperContext(), true);
                        if (null == unmarshaller) {
                            unmarshaller = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().createUnmarshaller();
                        }
                        unmarshaller.setUnmarshalListener(listener);
                        unmarshaller.getProperties().put("sdoHelperContext", this.aHelperContext);
                        unmarshaller.setUnmappedContentHandlerClass(SDOUnmappedContentHandler.class);
                        Object unmarshalledNode = unmarshaller.unmarshal(nextNode, nextModifiedDO.getType().getXmlDescriptor().getJavaClass());
                        SDODataObject unmarshalledDO = null;
                        if (unmarshalledNode instanceof XMLRoot) {
                            unmarshalledDO = (SDODataObject)((XMLRoot)unmarshalledNode).getObject();
                        } else if (unmarshalledNode instanceof DataObject) {
                            unmarshalledDO = (SDODataObject)unmarshalledNode;
                        }
                        ArrayList<SDOProperty> modifiedProps = new ArrayList<SDOProperty>();
                        TypeHelper typeHelper = this.aHelperContext.getTypeHelper();
                        for (Node n = nextNode.getFirstChild(); n != null; n = n.getNextSibling()) {
                            if (n.getNodeType() != 1) continue;
                            String propName = n.getLocalName();
                            SDOProperty nextProp2 = unmarshalledDO.getInstanceProperty(propName);
                            if (nextProp2 == null) {
                                nextProp2 = typeHelper.getOpenContentProperty(n.getNamespaceURI(), propName);
                            }
                            if (modifiedProps.contains(nextProp2)) continue;
                            modifiedProps.add(nextProp2);
                        }
                        int modifiedPropsSize = modifiedProps.size();
                        for (k = 0; k < modifiedPropsSize; ++k) {
                            Object value;
                            nextProp = (SDOProperty)modifiedProps.get(k);
                            if (!nextProp.getType().isDataType()) {
                                SDOSequence nextSeq;
                                if (nextProp.isMany()) {
                                    List originalValue = unmarshalledDO.getList(nextProp);
                                    ArrayList<SDODataObject> newList = new ArrayList<SDODataObject>();
                                    ArrayList<SDODataObject> toDelete = new ArrayList<SDODataObject>();
                                    ArrayList<Integer> indexsToDelete = new ArrayList<Integer>();
                                    int originalValueSize = originalValue.size();
                                    for (int l = 0; l < originalValueSize; ++l) {
                                        SDODataObject nextInList = (SDODataObject)originalValue.get(l);
                                        String sdoRef = nextInList._getSdoRef();
                                        if (sdoRef != null) {
                                            String sdoRefPath = this.convertXPathToSDOPath(sdoRef);
                                            int nextSlash = sdoRefPath.indexOf(47);
                                            sdoRefPath = nextSlash != -1 ? sdoRefPath.substring(nextSlash + 1) : "/";
                                            newList.add(targetDataObject.getDataObject(sdoRefPath));
                                            continue;
                                        }
                                        toDelete.add(nextInList);
                                        indexsToDelete.add(l);
                                        newList.add(nextInList);
                                    }
                                    ListWrapper lw = (ListWrapper)nextModifiedDO.getList(nextProp);
                                    int indexsToDeleteSize = indexsToDelete.size();
                                    if (indexsToDeleteSize > 0) {
                                        nextCS.pauseLogging();
                                        for (int m = 0; m < indexsToDeleteSize; ++m) {
                                            int toDeleteIndex = (Integer)indexsToDelete.get(m);
                                            SDODataObject nextToDelete = (SDODataObject)toDelete.get(m);
                                            lw.add(toDeleteIndex, nextToDelete);
                                        }
                                        nextCS.setPropertyInternal(nextModifiedDO, nextProp, lw);
                                        nextSeq = (SDOSequence)nextCS.getOriginalSequences().get(nextModifiedDO);
                                        nextCS.resumeLogging();
                                        nextModifiedDO._setModified(true);
                                        for (int m = indexsToDeleteSize - 1; m >= 0; --m) {
                                            int toDeleteIndex = (Integer)indexsToDelete.get(m);
                                            SDODataObject nextToDelete = (SDODataObject)toDelete.get(m);
                                            if (nextSeq != null) {
                                                nextSeq.addSettingWithoutModifyingDataObject(-1, nextProp, nextToDelete);
                                            }
                                            nextToDelete.resetChanges();
                                            lw.remove(toDeleteIndex);
                                        }
                                    }
                                    nextCS.getOriginalElements().put(lw, newList);
                                    continue;
                                }
                                value = unmarshalledDO.getDataObject(nextProp);
                                if (value != null) {
                                    String sdoRef = ((SDODataObject)value)._getSdoRef();
                                    if (sdoRef != null) {
                                        nextModifiedDO._setModified(true);
                                        continue;
                                    }
                                    ((SDODataObject)value)._setChangeSummary(nextCS);
                                    nextModifiedDO._setModified(true);
                                    nextCS.pauseLogging();
                                    boolean wasSet = nextModifiedDO.isSet(nextProp);
                                    Object existingValue = nextModifiedDO.get(nextProp);
                                    SDOSequence nextModifiedDOSequence = nextModifiedDO.getSequence();
                                    int settingIdx = -1;
                                    if (nextModifiedDOSequence != null) {
                                        settingIdx = nextModifiedDOSequence.getIndexForProperty(nextProp);
                                    }
                                    ((SDODataObject)value)._setContainmentPropertyName(null);
                                    ((SDODataObject)value)._setContainer(null);
                                    nextModifiedDO.set(nextProp, value);
                                    nextCS.setPropertyInternal(nextModifiedDO, nextProp, value);
                                    nextSeq = (SDOSequence)nextCS.getOriginalSequences().get(nextModifiedDO);
                                    if (nextSeq != null) {
                                        nextSeq.addSettingWithoutModifyingDataObject(-1, nextProp, value);
                                    }
                                    nextCS.resumeLogging();
                                    nextModifiedDO._setModified(true);
                                    ((SDODataObject)value).resetChanges();
                                    ((SDODataObject)value).delete();
                                    if (wasSet) {
                                        nextModifiedDO.set(nextProp, existingValue, false);
                                        if (settingIdx == -1) continue;
                                        nextModifiedDO.getSequence().addSettingWithoutModifyingDataObject(settingIdx, nextProp, existingValue);
                                        continue;
                                    }
                                    nextModifiedDO.unset(nextProp);
                                    continue;
                                }
                                nextModifiedDO._setModified(true);
                                nextCS.setPropertyInternal(nextModifiedDO, nextProp, null);
                                continue;
                            }
                            nextModifiedDO._setModified(true);
                            value = unmarshalledDO.get(nextProp);
                            if (nextProp.isMany()) {
                                SDOProperty theProp = nextModifiedDO.getInstanceProperty(nextProp.getName());
                                if (theProp == null) {
                                    Property newProp = nextModifiedDO.defineOpenContentProperty(nextProp.getName(), new ArrayList(), nextProp.getType());
                                    nextModifiedDO.set(newProp, new ArrayList());
                                    theProp = newProp;
                                }
                                List lw = nextModifiedDO.getList(theProp.getName());
                                nextCS.setPropertyInternal(nextModifiedDO, theProp, lw);
                                nextCS.getOriginalElements().put(lw, ((ListWrapper)value).getCurrentElements());
                                continue;
                            }
                            nextCS.setPropertyInternal(nextModifiedDO, nextProp, value);
                        }
                        int unsetValueListSize = unsetValueList.size();
                        for (k = 0; k < unsetValueListSize; ++k) {
                            nextProp = unmarshalledDO.getInstanceProperty((String)unsetValueList.get(k));
                            if (nextProp != null) {
                                Object oldValue = null;
                                if (nextProp.getType().isDataType() || nextProp.isMany()) {
                                    oldValue = unmarshalledDO.get(nextProp);
                                }
                                nextModifiedDO._setModified(true);
                                nextCS.setPropertyInternal(nextModifiedDO, nextProp, oldValue);
                                nextCS.unsetPropertyInternal(nextModifiedDO, nextProp);
                                continue;
                            }
                            nextProp = nextModifiedDO.getInstanceProperty((String)unsetValueList.get(k));
                            nextModifiedDO._setModified(true);
                            nextCS.setPropertyInternal(nextModifiedDO, nextProp, null);
                            nextCS.unsetPropertyInternal(nextModifiedDO, nextProp);
                        }
                        continue;
                    }
                    throw SDOException.errorProcessingXPath(refValue);
                }
                nextCS.setModifiedDoms(null);
                nextCS.setDeletedXPaths(null);
                List created = nextCS.getCreated();
                int createdSize = created.size();
                for (int j = 0; j < createdSize; ++j) {
                    SDODataObject next = (SDODataObject)created.get(j);
                    SDOProperty containmentProperty = next.getContainmentProperty();
                    if (containmentProperty == null || !containmentProperty.isMany()) continue;
                    SDODataObject container = next.getContainer();
                    ListWrapper list = (ListWrapper)container.get(containmentProperty);
                    if (nextCS.getOriginalElements().containsKey(list)) continue;
                    nextCS.getOriginalElements().put(list, new ArrayList());
                }
                nextCS.setLogging(loggingValue);
            }
            this.changeSummaries = null;
        }
    }

    private List<SDOChangeSummary> getChangeSummaries() {
        if (null == this.changeSummaries) {
            this.changeSummaries = new ArrayList<SDOChangeSummary>();
        }
        return this.changeSummaries;
    }

    private String convertXPathToSDOPath(String xpath) {
        if (xpath == null || xpath.length() < SDOConstants.SDO_CHANGESUMMARY_REF_PATH_PREFIX_LENGTH || !xpath.startsWith("#")) {
            throw SDOException.errorProcessingXPath(xpath);
        }
        if (xpath.equals("#/")) {
            return "/";
        }
        if (xpath.startsWith("#/")) {
            return xpath.substring(2, xpath.length());
        }
        return xpath.substring(1, xpath.length());
    }
}

