/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWModel
extends AbstractNodeModel
implements MWNode {
    protected MWModel() {
    }

    protected MWModel(MWNode parent) {
        super(parent);
    }

    public final MWNode getMWParent() {
        return (MWNode)this.getParent();
    }

    public final MWProject getProject() {
        if (this.getParent() == null) {
            try {
                return (MWProject)this;
            }
            catch (ClassCastException ex) {
                throw new IllegalStateException("This object is missing a parent: " + this);
            }
        }
        return this.getMWParent().getProject();
    }

    public final MWDatabase getDatabase() {
        MWRelationalProject project;
        try {
            project = (MWRelationalProject)this.getProject();
        }
        catch (ClassCastException cce) {
            throw new UnsupportedOperationException("This object is not in a relational project: " + this);
        }
        return project.getTableRepository();
    }

    public final MWClassRepository getRepository() {
        return this.getProject().getClassRepository();
    }

    public final MWClass typeNamed(String typeName) {
        return this.getRepository().typeNamedInternal(typeName);
    }

    public final MWClass typeFor(Class javaClass) {
        return this.typeNamed(javaClass.getName());
    }

    protected boolean removeNodeFromCollection(Node node, Collection collection, String collectionName) {
        boolean changed = this.removeItemFromCollection(node, collection, collectionName);
        if (changed) {
            this.getProject().nodeRemoved(node);
        }
        return changed;
    }

    protected boolean removeNodeFromCollection(Node node, Collection collection) {
        boolean changed = collection.remove(node);
        if (changed) {
            this.getProject().nodeRemoved(node);
        }
        return changed;
    }

    protected void nodesRemoved(Collection removedNodes) {
        this.nodesRemoved(removedNodes.iterator());
    }

    protected void nodesRemoved(Iterator removedNodes) {
        while (removedNodes.hasNext()) {
            this.getProject().nodeRemoved((Node)removedNodes.next());
        }
    }

    protected boolean removeNodesFromCollection(Collection nodes, Collection collection, String collectionName) {
        return this.removeNodesFromCollection(nodes.iterator(), collection, collectionName);
    }

    protected boolean removeNodesFromCollection(Iterator nodes, Collection collection, String collectionName) {
        Collection removedNodes = CollectionTools.collection(nodes);
        removedNodes.retainAll(collection);
        boolean changed = this.removeItemsFromCollection(nodes, collection, collectionName);
        this.nodesRemoved(removedNodes);
        return changed;
    }

    protected boolean removeNodesFromCollection(Collection nodes, Collection collection) {
        return this.removeNodesFromCollection(nodes.iterator(), collection);
    }

    protected boolean removeNodesFromCollection(Iterator nodes, Collection collection) {
        Collection removedNodes = CollectionTools.collection(nodes);
        removedNodes.retainAll(collection);
        boolean changed = collection.removeAll(removedNodes);
        this.nodesRemoved(removedNodes);
        return changed;
    }

    protected void clearNodeCollection(Collection nodeCollection, String collectionName) {
        ArrayList removedNodes = new ArrayList(nodeCollection);
        this.clearCollection(nodeCollection, collectionName);
        this.nodesRemoved(removedNodes);
    }

    protected void clearNodeCollection(Collection nodeCollection) {
        ArrayList removedNodes = new ArrayList(nodeCollection);
        nodeCollection.clear();
        this.nodesRemoved(removedNodes);
    }

    protected Object removeNodeFromList(int index, List nodeList, String listName) {
        Node removedNode = (Node)this.removeItemFromList(index, nodeList, listName);
        this.getProject().nodeRemoved(removedNode);
        return removedNode;
    }

    protected Object removeNodeFromList(int index, List list) {
        Node removedNode = (Node)list.remove(index);
        this.getProject().nodeRemoved(removedNode);
        return removedNode;
    }

    protected void clearNodeList(List nodeList, String listName) {
        ArrayList removedNodes = new ArrayList(nodeList);
        this.clearList(nodeList, listName);
        this.nodesRemoved(removedNodes);
    }

    protected void clearNodeList(List nodeList) {
        this.clearNodeCollection(nodeList);
    }

    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).mappingReplaced(oldMapping, newMapping);
        }
    }

    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).descriptorReplaced(oldDescriptor, newDescriptor);
        }
    }

    public void descriptorUnmapped(Collection mappings) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            MWNode child = (MWNode)stream.next();
            child.descriptorUnmapped(mappings);
        }
    }

    public final void resolveClassHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveClassHandles();
        }
    }

    public final void resolveMetadataHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveMetadataHandles();
        }
    }

    public final void resolveColumnHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveColumnHandles();
        }
    }

    public final void resolveReferenceHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveReferenceHandles();
        }
    }

    public final void resolveDescriptorHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveDescriptorHandles();
        }
    }

    public final void resolveMethodHandles() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).resolveMethodHandles();
        }
    }

    public void postProjectBuild() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            ((MWNode)stream.next()).postProjectBuild();
        }
    }

    public String displayString() {
        return this.toString();
    }

    protected void legacy60PostBuild(DescriptorEvent event) {
    }

    protected static XMLDescriptor legacy60BuildStandardDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.getEventManager().setPostBuildSelector("legacy60PostBuild");
        return descriptor;
    }

    public SortedSet buildBasicTypes() {
        TreeSet<MWTypeDeclaration> result = new TreeSet<MWTypeDeclaration>(this.buildBasicTypesComparator());
        result.add(new MWTypeDeclaration(this, this.typeFor(Boolean.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Byte.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Character.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Double.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Float.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Integer.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Long.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Short.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(String.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(BigDecimal.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(BigInteger.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Date.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Time.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Timestamp.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Calendar.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(java.util.Date.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Blob.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Clob.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Number.class)));
        result.add(new MWTypeDeclaration(this, this.typeFor(Byte.TYPE), 1));
        result.add(new MWTypeDeclaration(this, this.typeFor(Byte.class), 1));
        result.add(new MWTypeDeclaration(this, this.typeFor(Character.TYPE), 1));
        result.add(new MWTypeDeclaration(this, this.typeFor(Character.class), 1));
        return result;
    }

    private Comparator buildBasicTypesComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                MWTypeDeclaration c1 = (MWTypeDeclaration)o1;
                MWTypeDeclaration c2 = (MWTypeDeclaration)o2;
                int result = Collator.getInstance().compare(c1.shortTypeName(), c2.shortTypeName());
                if (result != 0) {
                    return result;
                }
                result = Collator.getInstance().compare(c1.typeName(), c2.typeName());
                if (result != 0) {
                    return result;
                }
                return c1.getDimensionality() - c2.getDimensionality();
            }
        };
    }

    public static String legacyReplaceToplinkDeprecatedClassReferences(String legacyClassName) {
        if ("org.eclipse.persistence.publicinterface.Descriptor".equals(legacyClassName)) {
            return "org.eclipse.persistence.descriptors.ClassDescriptor";
        }
        if ("org.eclipse.persistence.publicinterface.DescriptorEvent".equals(legacyClassName)) {
            return "org.eclipse.persistence.descriptors.DescriptorEvent";
        }
        return legacyClassName;
    }

    public static String legacyReplaceToplinkDepracatedClassReferencesFromSignature(String legacyMethodSignature) {
        if (legacyMethodSignature != null && legacyMethodSignature.contains("org.eclipse.persistence.publicinterface.Descriptor")) {
            legacyMethodSignature = legacyMethodSignature.contains("DescriptorEvent") ? legacyMethodSignature.replace("org.eclipse.persistence.publicinterface.DescriptorEvent", "org.eclipse.persistence.descriptors.DescriptorEvent") : legacyMethodSignature.replace("org.eclipse.persistence.publicinterface.Descriptor", "org.eclipse.persistence.descriptors.ClassDescriptor");
        }
        return legacyMethodSignature;
    }
}

