/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public abstract class MWAbstractReferenceMapping
extends MWMapping
implements MWReferenceMapping {
    private MWDescriptorHandle referenceDescriptorHandle;
    protected volatile String indirectionType;
    private volatile boolean privateOwned;
    private static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    protected MWAbstractReferenceMapping() {
    }

    protected MWAbstractReferenceMapping(MWMappingDescriptor descriptor, MWClassAttribute attribute, String attributeName) {
        super(descriptor, attribute, attributeName);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.referenceDescriptorHandle = new MWDescriptorHandle(this, this.buildReferenceDescriptorScrubber());
        this.privateOwned = false;
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (this.getInstanceVariable().isEjb20Attribute()) {
            this.forceEjb20Indirection();
        } else {
            this.indirectionType = this.getInstanceVariable().isValueHolder() ? "value-holder-indirection" : "no-indirection";
        }
    }

    protected void forceEjb20Indirection() {
        this.setUseValueHolderIndirection();
    }

    public MWDescriptor getReferenceDescriptor() {
        return this.referenceDescriptorHandle.getDescriptor();
    }

    public void setReferenceDescriptor(MWDescriptor newValue) {
        MWDescriptor oldValue = this.referenceDescriptorHandle.getDescriptor();
        this.referenceDescriptorHandle.setDescriptor(newValue);
        this.firePropertyChanged("referenceDescriptor", oldValue, newValue);
        if (newValue != null) {
            newValue.getProject().notifyExpressionsToRecalculateQueryables();
        } else {
            this.getProject().notifyExpressionsToRecalculateQueryables();
        }
    }

    public boolean isReferenceMapping() {
        return true;
    }

    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    protected void setIndirectionType(String indirectionType) {
        String oldValue = this.indirectionType;
        this.indirectionType = indirectionType;
        this.firePropertyChanged("indirection", oldValue, indirectionType);
    }

    protected String getIndirectionType() {
        return this.indirectionType;
    }

    public boolean isPrivateOwned() {
        return this.privateOwned;
    }

    public void setPrivateOwned(boolean newValue) {
        boolean oldValue = this.privateOwned;
        this.privateOwned = newValue;
        this.firePropertyChanged("privateOwned", oldValue, newValue);
    }

    protected void initializeFromMWReferenceObjectMapping(MWReferenceObjectMapping oldMapping) {
        super.initializeFromMWReferenceObjectMapping(oldMapping);
        this.setReferenceDescriptor(oldMapping.getReferenceDescriptor());
    }

    protected void initializeFromMWReferenceMapping(MWReferenceMapping oldMapping) {
        super.initializeFromMWReferenceMapping(oldMapping);
        this.setPrivateOwned(oldMapping.isPrivateOwned());
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping oldMapping) {
        super.initializeFromMWIndirectableMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (oldMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    public void automap() {
        super.automap();
        this.automapReferenceDescriptor();
    }

    private void automapReferenceDescriptor() {
        if (this.getReferenceDescriptor() != null) {
            return;
        }
        MWDescriptor referenceDescriptor = this.findReferenceDescriptor();
        if (referenceDescriptor != null) {
            this.setReferenceDescriptor(referenceDescriptor);
        }
    }

    private MWDescriptor findReferenceDescriptor() {
        MWClass type = this.getInstanceVariable().getType();
        String name = type.isPrimitive() || type.isValueHolder() || type.isAssignableToMap() || type.isAssignableToCollection() || type.isAssignableTo(this.typeFor(Number.class)) || type == this.typeFor(String.class) ? this.getName() : type.shortName();
        CollectionStringHolder[] holders = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore shs = this.match(name.toLowerCase(), holders);
        if (shs.getScore() < 0.8) {
            return null;
        }
        String packageName = this.getParentDescriptor().packageName();
        MWDescriptor descriptor = null;
        Iterator stream = ((CollectionStringHolder)shs.getStringHolder()).iterator();
        while (stream.hasNext()) {
            descriptor = (MWDescriptor)stream.next();
            if (!descriptor.packageName().equals(packageName)) continue;
            return descriptor;
        }
        return descriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        Collection descriptors = this.candidateReferenceDescriptors();
        HashMap<String, CollectionStringHolder> holders = new HashMap<String, CollectionStringHolder>(descriptors.size());
        for (MWDescriptor descriptor : descriptors) {
            String shortName = descriptor.shortName().toLowerCase();
            CollectionStringHolder holder = (CollectionStringHolder)holders.get(shortName);
            if (holder == null) {
                holder = new CollectionStringHolder(shortName);
                holders.put(shortName, holder);
            }
            holder.add(descriptor);
        }
        return holders.values().toArray(new CollectionStringHolder[holders.size()]);
    }

    private Collection candidateReferenceDescriptors() {
        ArrayList<MWDescriptor> descriptors = new ArrayList<MWDescriptor>();
        Iterator stream = this.getProject().descriptors();
        while (stream.hasNext()) {
            MWDescriptor descriptor = (MWDescriptor)stream.next();
            if (!this.descriptorIsValidReferenceDescriptor(descriptor)) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] multiDescriptorStringHolders) {
        return PARTIAL_STRING_MATCHER.match(string, multiDescriptorStringHolders);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.referenceDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAbstractReferenceMapping.this.setReferenceDescriptor(null);
            }

            public String toString() {
                return "MWAbstractReferenceMapping.buildReferenceDescriptorScrubber()";
            }
        };
    }

    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        super.descriptorReplaced(oldDescriptor, newDescriptor);
        if (this.getReferenceDescriptor() == oldDescriptor) {
            this.setReferenceDescriptor(newDescriptor);
        }
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkReferenceDescriptor(newProblems);
        this.checkIndirection(newProblems);
    }

    protected void checkReferenceDescriptor(List newProblems) {
        MWDescriptor refDescriptor = this.getReferenceDescriptor();
        if (refDescriptor == null) {
            newProblems.add(this.buildProblem("0450"));
        } else {
            if (!this.descriptorIsValidReferenceDescriptor(refDescriptor)) {
                newProblems.add(this.buildProblem(this.referenceDescriptorInvalidProblemString()));
            }
            if (!refDescriptor.isActive()) {
                newProblems.add(this.buildProblem("0451", this.getInstanceVariable().getName(), this.getReferenceDescriptor().getMWClass().shortName()));
            }
            this.checkReferenceDescriptorCachIsolation(newProblems);
        }
    }

    protected abstract String referenceDescriptorInvalidProblemString();

    protected void checkReferenceDescriptorCachIsolation(List newProblems) {
        MWCachingPolicy policy = this.getParentDescriptor().getTransactionalPolicy().getCachingPolicy();
        String cacheIsolation = policy.getCacheIsolation().getMWModelOption();
        if (cacheIsolation == "DEFAULT") {
            policy = policy.getProject().getDefaultsPolicy().getCachingPolicy();
            cacheIsolation = policy.getCacheIsolation().getMWModelOption();
        }
        if (cacheIsolation == "Shared") {
            policy = this.getReferenceDescriptor().getTransactionalPolicy().getCachingPolicy();
            String referenceCacheIsolation = policy.getCacheIsolation().getMWModelOption();
            if (referenceCacheIsolation == "DEFAULT") {
                policy = policy.getProject().getDefaultsPolicy().getCachingPolicy();
                referenceCacheIsolation = policy.getCacheIsolation().getMWModelOption();
            }
            if (referenceCacheIsolation == "Isolated") {
                newProblems.add(this.buildProblem("0452", this.getReferenceDescriptor().getName(), this.getName()));
            }
        }
    }

    protected void checkIndirection(List newProblems) {
        if (this.usesValueHolderIndirection()) {
            if (this.getInstanceVariable().isTLValueHolder()) {
                newProblems.add(this.buildProblem("0552"));
            } else if (!this.getProject().usesWeaving() && !this.getInstanceVariable().isValueHolder()) {
                newProblems.add(this.buildProblem("0551"));
            }
        } else if (this.getInstanceVariable().isValueHolder()) {
            newProblems.add(this.buildProblem("0550"));
        }
    }

    public DatabaseMapping runtimeMapping() {
        ForeignReferenceMapping runtimeMapping = (ForeignReferenceMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null) {
            runtimeMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        if (this.usesValueHolderIndirection()) {
            runtimeMapping.useBasicIndirection();
        } else {
            runtimeMapping.dontUseIndirection();
        }
        runtimeMapping.setIsPrivateOwned(this.isPrivateOwned());
        return runtimeMapping;
    }

    public void toString(StringBuffer sb) {
        if (this.getInstanceVariable() == null) {
            sb.append("<no instance variable>");
        } else {
            sb.append(this.getInstanceVariable().getName());
        }
        sb.append(" -> ");
        if (this.getReferenceDescriptor() == null) {
            sb.append("<no reference descriptor selected>");
        } else {
            sb.append(this.getReferenceDescriptor().getMWClass().shortName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractReferenceMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping referenceDescriptorMapping = new XMLCompositeObjectMapping();
        referenceDescriptorMapping.setAttributeName("referenceDescriptorHandle");
        referenceDescriptorMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setReferenceClass(MWDescriptorHandle.class);
        referenceDescriptorMapping.setXPath("reference-descriptor-handle");
        descriptor.addMapping((DatabaseMapping)referenceDescriptorMapping);
        ObjectTypeConverter indirectionTypeConverter = new ObjectTypeConverter();
        indirectionTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        indirectionTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        indirectionTypeConverter.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        indirectionTypeConverter.addConversionValue((Object)"proxy-indirection", (Object)"proxy-indirection");
        XMLDirectMapping indirectionTypeMapping = new XMLDirectMapping();
        indirectionTypeMapping.setAttributeName("indirectionType");
        indirectionTypeMapping.setXPath("indirection-type/text()");
        indirectionTypeMapping.setNullValue((Object)"no-indirection");
        indirectionTypeMapping.setConverter((Converter)indirectionTypeConverter);
        descriptor.addMapping((DatabaseMapping)indirectionTypeMapping);
        XMLDirectMapping privateOwnedMapping = (XMLDirectMapping)descriptor.addDirectMapping("privateOwned", "private-owned/text()");
        privateOwnedMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private MWDescriptorHandle getReferenceDescriptorHandleForTopLink() {
        return this.referenceDescriptorHandle.getDescriptor() == null ? null : this.referenceDescriptorHandle;
    }

    private void setReferenceDescriptorHandleForTopLink(MWDescriptorHandle referenceDescriptorHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceDescriptorScrubber();
        this.referenceDescriptorHandle = referenceDescriptorHandle == null ? new MWDescriptorHandle(this, scrubber) : referenceDescriptorHandle.setScrubber(scrubber);
    }
}

