/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregatePathToColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWAggregateMapping
extends MWMapping
implements MWReferenceObjectMapping {
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";
    private Collection pathsToFields;
    public static final String PATHS_TO_FIELDS_COLLECTION = "pathsToFields";
    private MWDescriptorHandle referenceDescriptorHandle;
    private static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    private MWAggregateMapping() {
    }

    MWAggregateMapping(MWMappingDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.pathsToFields = new Vector();
        this.referenceDescriptorHandle = new MWDescriptorHandle(this, this.buildReferenceDescriptorScrubber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.pathsToFields;
        synchronized (collection) {
            children.addAll(this.pathsToFields);
        }
        children.add(this.referenceDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAggregateMapping.this.setReferenceDescriptor(null);
            }

            public String toString() {
                return "MWAggregateMapping.buildReferenceDescriptorScrubber()";
            }
        };
    }

    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        if (this.getReferenceDescriptor() == oldDescriptor) {
            this.setReferenceDescriptor(newDescriptor);
        }
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean newValue) {
        boolean oldValue = this.allowsNull;
        this.allowsNull = newValue;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, oldValue, newValue);
    }

    public Iterator pathsToFields() {
        return new CloneIterator(this.pathsToFields);
    }

    public int pathsToFieldsSize() {
        return this.pathsToFields.size();
    }

    private Collection getPathsToFieldsDeepCopy(MWAggregateMapping newParent) {
        Vector<MWAggregatePathToColumn> result = new Vector<MWAggregatePathToColumn>(this.pathsToFields.size());
        Iterator stream = this.pathsToFields();
        while (stream.hasNext()) {
            result.add(((MWAggregatePathToColumn)stream.next()).copy(newParent));
        }
        return result;
    }

    public MWDescriptor getReferenceDescriptor() {
        return this.referenceDescriptorHandle.getDescriptor();
    }

    public void setReferenceDescriptor(MWDescriptor referenceDescriptor) {
        MWDescriptor oldValue = this.getReferenceDescriptor();
        this.referenceDescriptorHandle.setDescriptor(referenceDescriptor);
        this.firePropertyChanged("referenceDescriptor", oldValue, referenceDescriptor);
        this.updatePathsToFields();
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor(), this);
        if (referenceDescriptor != null) {
            referenceDescriptor.getProject().notifyExpressionsToRecalculateQueryables();
        } else {
            this.getProject().notifyExpressionsToRecalculateQueryables();
        }
    }

    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor descriptor) {
        return ((MWRelationalDescriptor)((Object)descriptor)).isAggregateDescriptor();
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWAggregateMapping(this);
    }

    protected void initializeFromMWReferenceObjectMapping(MWReferenceObjectMapping oldMapping) {
        super.initializeFromMWReferenceObjectMapping(oldMapping);
        this.setReferenceDescriptor(oldMapping.getReferenceDescriptor());
    }

    public MWAggregateMapping asMWAggregateMapping() {
        return this;
    }

    private void insertRootNodeIntoAll(MWMapping rootNode, Collection subAPTFs) {
        for (MWAggregatePathToColumn aptf : subAPTFs) {
            aptf.insertRootMappingNode(rootNode);
        }
    }

    private boolean compareAPTFs(MWAggregatePathToColumn aptf1, MWAggregatePathToColumn aptf2) {
        return aptf1.getMappingNodes().containsAll(aptf2.getMappingNodes()) && aptf2.getMappingNodes().containsAll(aptf1.getMappingNodes()) && aptf1.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime().equals(aptf2.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime());
    }

    private boolean collectionRemoveAPTF(Collection collection, MWAggregatePathToColumn aptf) {
        Iterator stream = collection.iterator();
        while (stream.hasNext()) {
            if (!this.compareAPTFs((MWAggregatePathToColumn)stream.next(), aptf)) continue;
            stream.remove();
            return true;
        }
        return false;
    }

    private void mergePathsToFields(Collection recalculatedPathsToFields) {
        Iterator stream = this.pathsToFields.iterator();
        while (stream.hasNext()) {
            MWAggregatePathToColumn aptf = (MWAggregatePathToColumn)stream.next();
            if (this.collectionRemoveAPTF(recalculatedPathsToFields, aptf)) continue;
            stream.remove();
        }
        this.addItemsToCollection(recalculatedPathsToFields, this.pathsToFields, PATHS_TO_FIELDS_COLLECTION);
    }

    private MWAggregatePathToColumn buildAPTF(MWMapping node, AggregateRuntimeFieldNameGenerator aggregateFieldNameGenerator) {
        MWAggregatePathToColumn newAPTF = new MWAggregatePathToColumn(this);
        newAPTF.addMappingNode(node);
        newAPTF.setAggregateRuntimeFieldNameGenerator(aggregateFieldNameGenerator);
        return newAPTF;
    }

    private MWAggregatePathToColumn buildAPTF(AggregateRuntimeFieldNameGenerator aggregateFieldNameGenerator) {
        MWAggregatePathToColumn newAPTF = new MWAggregatePathToColumn(this);
        newAPTF.setAggregateRuntimeFieldNameGenerator(aggregateFieldNameGenerator);
        return newAPTF;
    }

    public void updatePathsToFields() {
        ArrayList<MWAggregatePathToColumn> newAPTFs = new ArrayList<MWAggregatePathToColumn>();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor() != this.getParentDescriptor()) {
            Iterator stream1 = this.getReferenceDescriptor().mappingsIncludingInherited();
            while (stream1.hasNext()) {
                MWMapping subMapping = (MWMapping)stream1.next();
                if (subMapping instanceof MWAggregateMapping) {
                    ((MWAggregateMapping)subMapping).updatePathsToFields();
                    Collection subAPTFs = ((MWAggregateMapping)subMapping).getPathsToFieldsDeepCopy(this);
                    this.insertRootNodeIntoAll(subMapping, subAPTFs);
                    newAPTFs.addAll(subAPTFs);
                    continue;
                }
                Iterator stream2 = subMapping.aggregateFieldNameGenerators();
                while (stream2.hasNext()) {
                    newAPTFs.add(this.buildAPTF(subMapping, (AggregateRuntimeFieldNameGenerator)stream2.next()));
                }
            }
            Iterator stream = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
            while (stream.hasNext()) {
                newAPTFs.add(this.buildAPTF((AggregateRuntimeFieldNameGenerator)stream.next()));
            }
        }
        this.mergePathsToFields(newAPTFs);
        this.fireCollectionChanged(PATHS_TO_FIELDS_COLLECTION);
    }

    public String initialValue(MWClassCodeGenPolicy classCodeGenPolicy) {
        String initialValue = super.initialValue(classCodeGenPolicy);
        if (!this.allowsNull()) {
            if (this.getReferenceDescriptor() != null) {
                initialValue = this.getInstanceVariable().initialValueSourceCodeFor(this.getReferenceDescriptor().getMWClass());
            }
            if ("".equals(initialValue)) {
                initialValue = classCodeGenPolicy.aggregateMappingDoesNotAllowNullImplementationClassNotDeterminedComment() + StringTools.CR + "\t\t" + null;
            }
            initialValue = StringTools.CR + "\t\t" + classCodeGenPolicy.aggregateMappingDoesNotAllowNullComment(this) + StringTools.CR + "\t\t" + initialValue;
        }
        return initialValue;
    }

    public boolean allowsChildren() {
        return true;
    }

    public boolean isLeaf(Filter queryableFilter) {
        return this.subQueryableElements(queryableFilter).size() == 0;
    }

    public List subQueryableElements(Filter queryableFilter) {
        List subQueryableElements = new ArrayList();
        if (this.getReferenceDescriptor() != null) {
            subQueryableElements = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).getQueryables(queryableFilter);
            Collections.sort(subQueryableElements, DEFAULT_COMPARATOR);
        }
        return subQueryableElements;
    }

    public MWQueryable subQueryableElementAt(int index, Filter queryableFilter) {
        return (MWQueryable)this.subQueryableElements(queryableFilter).get(index);
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    public String iconKey() {
        return "mapping.aggregate";
    }

    public void automap() {
        super.automap();
        this.automapReferenceDescriptor();
    }

    private void automapReferenceDescriptor() {
        if (this.getReferenceDescriptor() != null) {
            return;
        }
        MWDescriptor referenceDescriptor = this.findReferenceDescriptor();
        if (referenceDescriptor != null) {
            this.setReferenceDescriptor(referenceDescriptor);
        }
    }

    private MWDescriptor findReferenceDescriptor() {
        MWClass type = this.getInstanceVariable().getType();
        String name = type.isPrimitive() || type.isValueHolder() || type.isAssignableToMap() || type.isAssignableToCollection() || type.isAssignableTo(this.typeFor(Number.class)) || type == this.typeFor(String.class) ? this.getName() : type.shortName();
        CollectionStringHolder[] holders = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore shs = this.match(name.toLowerCase(), holders);
        if (shs.getScore() < 0.8) {
            return null;
        }
        String packageName = this.getParentDescriptor().packageName();
        MWDescriptor descriptor = null;
        Iterator stream = ((CollectionStringHolder)shs.getStringHolder()).iterator();
        while (stream.hasNext()) {
            descriptor = (MWDescriptor)stream.next();
            if (!descriptor.packageName().equals(packageName)) continue;
            return descriptor;
        }
        return descriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        Collection descriptors = this.candidateReferenceDescriptors();
        HashMap<String, CollectionStringHolder> holders = new HashMap<String, CollectionStringHolder>(descriptors.size());
        for (MWDescriptor descriptor : descriptors) {
            String shortName = descriptor.shortName().toLowerCase();
            CollectionStringHolder holder = (CollectionStringHolder)holders.get(shortName);
            if (holder == null) {
                holder = new CollectionStringHolder(shortName);
                holders.put(shortName, holder);
            }
            holder.add(descriptor);
        }
        return holders.values().toArray(new CollectionStringHolder[holders.size()]);
    }

    private Collection candidateReferenceDescriptors() {
        ArrayList<MWDescriptor> descriptors = new ArrayList<MWDescriptor>();
        Iterator stream = this.getProject().descriptors();
        while (stream.hasNext()) {
            MWDescriptor descriptor = (MWDescriptor)stream.next();
            if (!this.descriptorIsCandidateReferenceDescriptor(descriptor)) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private boolean descriptorIsCandidateReferenceDescriptor(MWDescriptor descriptor) {
        return descriptor != this.getParentDescriptor() && ((MWRelationalDescriptor)((Object)descriptor)).isAggregateDescriptor();
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] multiDescriptorStringHolders) {
        return PARTIAL_STRING_MATCHER.match(string, multiDescriptorStringHolders);
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkReferenceDescriptorIsValid(newProblems);
        this.checkColumnsAreUnique(newProblems);
        this.checkColumnsAreValid(newProblems);
    }

    private void checkReferenceDescriptorIsValid(List newProblems) {
        if (this.getReferenceDescriptor() == null) {
            newProblems.add(this.buildProblem("0450"));
        } else if (!this.getReferenceDescriptor().isActive()) {
            newProblems.add(this.buildProblem("0451", this.getInstanceVariable().getName(), this.getReferenceDescriptor().getMWClass().shortName()));
        } else if (!this.descriptorIsValidReferenceDescriptor(this.getReferenceDescriptor())) {
            newProblems.add(this.buildProblem("0570"));
        }
    }

    private void checkColumnsAreUnique(List newProblems) {
        if (this.getParentDescriptor() instanceof MWAggregateDescriptor) {
            return;
        }
        int numFields = this.pathsToFieldsSize();
        HashSet<MWColumn> writeableFieldsSet = new HashSet<MWColumn>(numFields);
        Iterator stream = this.pathsToFields();
        while (stream.hasNext()) {
            MWAggregatePathToColumn pathToField = (MWAggregatePathToColumn)stream.next();
            MWColumn field = pathToField.getColumn();
            if (field == null || !pathToField.fieldIsWritten() || writeableFieldsSet.add(field)) continue;
            newProblems.add(this.buildProblem("0572"));
        }
    }

    private void checkColumnsAreValid(List newProblems) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        Iterator stream = this.pathsToFields();
        while (stream.hasNext()) {
            MWColumn field = ((MWAggregatePathToColumn)stream.next()).getColumn();
            if (field == null) {
                newProblems.add(this.buildProblem("0571"));
                continue;
            }
            if (CollectionTools.contains(((MWTableDescriptor)this.getParentDescriptor()).allAssociatedColumns(), (Object)field)) continue;
            newProblems.add(this.buildProblem("0573"));
        }
    }

    public void addWrittenFieldsTo(Collection writtenFields) {
        Iterator stream = this.pathsToFields();
        while (stream.hasNext()) {
            MWAggregatePathToColumn pathToField = (MWAggregatePathToColumn)stream.next();
            if (pathToField.getColumn() == null || !pathToField.fieldIsWritten()) continue;
            writtenFields.add(pathToField.getColumn());
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new AggregateObjectMapping();
    }

    public DatabaseMapping runtimeMapping() {
        AggregateObjectMapping runtimeMapping = (AggregateObjectMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null) {
            runtimeMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        runtimeMapping.setIsNullAllowed(this.allowsNull());
        this.convertPathsToFieldsToRuntime(runtimeMapping);
        return runtimeMapping;
    }

    private void convertPathsToFieldsToRuntime(AggregateObjectMapping runtimeMapping) {
        Iterator i = this.pathsToFields();
        while (i.hasNext()) {
            MWAggregatePathToColumn pathToField = (MWAggregatePathToColumn)i.next();
            pathToField.adjustRuntimeMapping(runtimeMapping);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAggregateMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping referenceDescriptorHandleMapping = new XMLCompositeObjectMapping();
        referenceDescriptorHandleMapping.setAttributeName("referenceDescriptorHandle");
        referenceDescriptorHandleMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        referenceDescriptorHandleMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        referenceDescriptorHandleMapping.setReferenceClass(MWDescriptorHandle.class);
        referenceDescriptorHandleMapping.setXPath("reference-descriptor-handle");
        descriptor.addMapping((DatabaseMapping)referenceDescriptorHandleMapping);
        XMLDirectMapping allowsNullMapping = (XMLDirectMapping)descriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()");
        allowsNullMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping pathsToFieldsMapping = new XMLCompositeCollectionMapping();
        pathsToFieldsMapping.setAttributeName(PATHS_TO_FIELDS_COLLECTION);
        pathsToFieldsMapping.setGetMethodName("getPathsToFieldsForTopLink");
        pathsToFieldsMapping.setSetMethodName("setPathsToFieldsForTopLink");
        pathsToFieldsMapping.setReferenceClass(MWAggregatePathToColumn.class);
        pathsToFieldsMapping.setXPath("paths-to-fields/aggregate-path-to-field");
        descriptor.addMapping((DatabaseMapping)pathsToFieldsMapping);
        return descriptor;
    }

    private MWDescriptorHandle getReferenceDescriptorHandleForTopLink() {
        return this.referenceDescriptorHandle.getDescriptor() == null ? null : this.referenceDescriptorHandle;
    }

    private void setReferenceDescriptorHandleForTopLink(MWDescriptorHandle referenceDescriptorHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceDescriptorScrubber();
        this.referenceDescriptorHandle = referenceDescriptorHandle == null ? new MWDescriptorHandle(this, scrubber) : referenceDescriptorHandle.setScrubber(scrubber);
    }

    private Collection getPathsToFieldsForTopLink() {
        return this.pathsToFields;
    }

    private void setPathsToFieldsForTopLink(Collection pathsToFields) {
        this.pathsToFields = pathsToFields;
    }
}

