/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryParameter
extends MWModel
implements MWQueryItem {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWClassHandle typeHandle;
    public static final String TYPE_PROPERTY = "type";

    private MWQueryParameter() {
    }

    MWQueryParameter(MWAbstractQuery query, String name, MWClass type) {
        super(query);
        this.name = name;
        this.typeHandle.setType(type);
    }

    protected void initialize(Node parentNode) {
        super.initialize(parentNode);
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.typeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWQueryParameter.this.setType(null);
            }

            public String toString() {
                return "MWQueryParameter.buildTypeScrubber()";
            }
        };
    }

    public MWQuery getQuery() {
        return (MWQuery)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            this.firePropertyChanged(NAME_PROPERTY, old, name);
            this.getProject().nodeRenamed(this);
        }
    }

    public MWClass getType() {
        return this.typeHandle.getType();
    }

    public void setType(MWClass type) {
        if (type == null) {
            throw new NullPointerException();
        }
        MWClass old = this.typeHandle.getType();
        this.typeHandle.setType(type);
        if (this.attributeValueHasChanged(old, type)) {
            this.firePropertyChanged(TYPE_PROPERTY, old, type);
            this.getQuery().signatureChanged();
        }
    }

    public void removeSelfFromParent() {
        this.getQuery().removeParameter(this);
    }

    void convertToRuntime(ObjectLevelReadQuery runtimeQuery) {
        runtimeQuery.addArgumentByTypeName(this.getName(), this.getType().getName());
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryParameter.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLCompositeObjectMapping typeHandleMapping = new XMLCompositeObjectMapping();
        typeHandleMapping.setAttributeName("typeHandle");
        typeHandleMapping.setGetMethodName("getTypeHandleForTopLink");
        typeHandleMapping.setSetMethodName("setTypeHandleForTopLink");
        typeHandleMapping.setReferenceClass(MWClassHandle.class);
        typeHandleMapping.setXPath("type-handle");
        descriptor.addMapping((DatabaseMapping)typeHandleMapping);
        DatabaseMapping typeNameMapping = descriptor.addDirectMapping("typeName", "legacyDP4GetTypeName", "legacyDP4SetTypeName", "type/text()");
        typeNameMapping.setIsReadOnly(true);
        return descriptor;
    }

    private MWClassHandle getTypeHandleForTopLink() {
        return this.typeHandle.getType() == null ? null : this.typeHandle;
    }

    private void setTypeHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTypeScrubber();
        this.typeHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private String legacyDP4GetTypeName() {
        throw new UnsupportedOperationException();
    }

    private void legacyDP4SetTypeName(String typeName) {
        if (typeName != null) {
            this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
            this.typeHandle.legacySetTypeNameForTopLink(typeName);
        }
    }
}

