/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalTable
implements ExternalTable {
    private final JDBCExternalTableDescription tableDescription;
    private final JDBCExternalColumn[] columns;
    private final ExternalForeignKey[] foreignKeys;
    private static final JDBCExternalForeignKey[] EMPTY_FOREIGN_KEYS = new JDBCExternalForeignKey[0];

    JDBCExternalTable(JDBCExternalTableDescription tableDescription) throws SQLException {
        this.tableDescription = tableDescription;
        this.columns = this.buildColumns();
        this.markPrimaryKeyColumns();
        this.foreignKeys = this.buildForeignKeys();
    }

    private JDBCExternalColumn[] buildColumns() throws SQLException {
        ArrayList<JDBCExternalColumn> cols = new ArrayList<JDBCExternalColumn>();
        ResultSet resultSet = this.metaData().getColumns(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName(), null);
        while (resultSet.next()) {
            cols.add(new JDBCExternalColumn(resultSet));
        }
        resultSet.close();
        return cols.toArray(new JDBCExternalColumn[cols.size()]);
    }

    private void markPrimaryKeyColumns() {
        Collection pkColNames = this.primaryKeyColumnNames();
        int i = this.columns.length;
        while (i-- > 0) {
            JDBCExternalColumn column = this.columns[i];
            column.setPrimaryKey(pkColNames.contains(column.getName()));
        }
    }

    private Collection primaryKeyColumnNames() {
        try {
            return this.primaryKeyColumnNames2();
        }
        catch (SQLException sQLException) {
            return Collections.EMPTY_SET;
        }
    }

    private Collection primaryKeyColumnNames2() throws SQLException {
        HashSet<String> names = new HashSet<String>();
        ResultSet resultSet = this.metaData().getPrimaryKeys(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName());
        while (resultSet.next()) {
            names.add(resultSet.getString(4).trim());
        }
        resultSet.close();
        return names;
    }

    private JDBCExternalForeignKey[] buildForeignKeys() {
        try {
            return this.buildForeignKeys2();
        }
        catch (SQLException sQLException) {
            return EMPTY_FOREIGN_KEYS;
        }
    }

    private JDBCExternalForeignKey[] buildForeignKeys2() throws SQLException {
        ArrayList<JDBCExternalForeignKey> fKeys = new ArrayList<JDBCExternalForeignKey>();
        ResultSet resultSet = this.metaData().getImportedKeys(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName());
        while (resultSet.next()) {
            String fKeyName = resultSet.getString(12).trim();
            JDBCExternalForeignKey fKey = this.foreignKeyNamed(fKeyName, fKeys);
            if (fKey == null) {
                fKey = new JDBCExternalForeignKey(this, fKeyName, resultSet);
                fKeys.add(fKey);
            }
            fKey.addColumnPair(resultSet);
        }
        resultSet.close();
        return fKeys.toArray(new JDBCExternalForeignKey[fKeys.size()]);
    }

    private JDBCExternalForeignKey foreignKeyNamed(String fKeyName, Collection fKeys) {
        for (JDBCExternalForeignKey fKey : fKeys) {
            if (!fKey.getName().equals(fKeyName)) continue;
            return fKey;
        }
        return null;
    }

    public ExternalColumn[] getColumns() {
        return this.columns;
    }

    public ExternalForeignKey[] getForeignKeys() {
        return this.foreignKeys;
    }

    private DatabaseMetaData metaData() {
        return this.tableDescription.metaData();
    }

    JDBCExternalDatabase database() {
        return this.tableDescription.getDatabase();
    }

    JDBCExternalColumn columnNamed(String columnName) {
        int i = this.columns.length;
        while (i-- > 0) {
            JDBCExternalColumn column = this.columns[i];
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.tableDescription.getQualifiedName());
    }
}

