/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile;

import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Field;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CFExternalClass
implements ExternalClass {
    private final ClassFile classFile;
    private final CFExternalClassDescription classDescription;

    CFExternalClass(ClassFile classFile, CFExternalClassDescription classDescription) {
        this.classFile = classFile;
        this.classDescription = classDescription;
    }

    public ExternalClassDescription[] getDeclaredClasses() {
        return this.buildClassDescriptionArray(this.classFile.declaredMemberClassNames());
    }

    public ExternalConstructor[] getDeclaredConstructors() {
        return this.buildConstructorArray(this.classFile.getMethodPool().declaredConstructors());
    }

    public ExternalField[] getDeclaredFields() {
        return this.buildFieldArray(this.classFile.getFieldPool().declaredFields());
    }

    public ExternalMethod[] getDeclaredMethods() {
        return this.buildMethodArray(this.classFile.getMethodPool().declaredMethods());
    }

    public ExternalClassDescription getDeclaringClass() {
        return this.classDescriptionNamed(this.classFile.declaringClassName());
    }

    public ExternalClassDescription[] getInterfaces() {
        return this.buildClassDescriptionArray(this.classFile.interfaceNames());
    }

    public int getModifiers() {
        return this.classFile.standardAccessFlags();
    }

    public String getName() {
        return this.classFile.className();
    }

    public ExternalClassDescription getSuperclass() {
        return this.classDescriptionNamed(this.classFile.superClassName());
    }

    public boolean isInterface() {
        return this.classFile.isInterface();
    }

    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionNamed(String className) {
        if (className == null) {
            return null;
        }
        return this.classDescription.classDescriptionNamed(className);
    }

    private ExternalClassDescription[] buildClassDescriptionArray(String[] classNames) {
        ExternalClassDescription[] classDescriptions = new ExternalClassDescription[classNames.length];
        int i = classNames.length;
        while (i-- > 0) {
            classDescriptions[i] = this.classDescriptionNamed(classNames[i]);
        }
        return classDescriptions;
    }

    private ExternalConstructor[] buildConstructorArray(Method[] constructors) {
        ExternalConstructor[] externalConstructors = new ExternalConstructor[constructors.length];
        int i = constructors.length;
        while (i-- > 0) {
            externalConstructors[i] = new CFExternalConstructor(constructors[i], this);
        }
        return externalConstructors;
    }

    private ExternalField[] buildFieldArray(Field[] fields) {
        ExternalField[] externalFields = new ExternalField[fields.length];
        int i = fields.length;
        while (i-- > 0) {
            externalFields[i] = new CFExternalField(fields[i], this);
        }
        return externalFields;
    }

    private ExternalMethod[] buildMethodArray(Method[] methods) {
        ExternalMethod[] externalMethods = new ExternalMethod[methods.length];
        int i = methods.length;
        while (i-- > 0) {
            externalMethods[i] = new CFExternalMethod(methods[i], this);
        }
        return externalMethods;
    }
}

