/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringReader;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.MemberRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;

public abstract class AbstractMethodRefConstant
extends MemberRefConstant {
    private FieldType returnDescriptor;
    private FieldType[] parameterDescriptors;

    AbstractMethodRefConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    public boolean isStaticInitializationMethod() {
        return this.name().equals("<clinit>");
    }

    public void accept(Visitor visitor) {
        this.getReturnDescriptor().accept(visitor);
        FieldType[] ptds = this.getParameterDescriptors();
        int len = ptds.length;
        for (int i = 0; i < len; ++i) {
            ptds[i].accept(visitor);
        }
    }

    public FieldType getReturnDescriptor() {
        if (this.returnDescriptor == null) {
            this.buildDescriptors();
        }
        return this.returnDescriptor;
    }

    public FieldType[] getParameterDescriptors() {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors;
    }

    public FieldType getParameterDescriptor(int index) {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors[index];
    }

    private void buildDescriptors() {
        StringReader reader = new StringReader(this.descriptor());
        try {
            this.parameterDescriptors = Method.buildParameterDescriptors(reader);
            this.returnDescriptor = FieldType.createFieldType(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

