/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.DoubleConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FloatConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.IntegerConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.LongConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.StringConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ConstantValueAttribute
extends Attribute {
    private short constantValueIndex;

    ConstantValueAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        this.constantValueIndex = stream.readU2();
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        this.constantValue().displayStringOn(writer);
        writer.println();
    }

    public void printFieldInitializationClauseOn(PrintWriter writer) {
        writer.print(" = ");
        this.constantValue().printFieldInitializationClauseOn(writer);
    }

    public Object fieldConstantValue() {
        return this.constantValue().value();
    }

    public Constant constantValue() {
        return this.constantPool().get(this.constantValueIndex);
    }

    public LongConstant longValue() {
        return (LongConstant)this.constantValue();
    }

    public FloatConstant floatValue() {
        return (FloatConstant)this.constantValue();
    }

    public DoubleConstant doubleValue() {
        return (DoubleConstant)this.constantValue();
    }

    public IntegerConstant integerValue() {
        return (IntegerConstant)this.constantValue();
    }

    public StringConstant stringValue() {
        return (StringConstant)this.constantValue();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public short getConstantValueIndex() {
        return this.constantValueIndex;
    }

    void toString(StringBuffer sb) {
        this.constantValue().toString(sb);
    }
}

