/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class MapEntryDiff
implements Diff {
    private final Map.Entry entry1;
    private final Map.Entry entry2;
    private final Diff keyDiff;
    private final Diff valueDiff;
    private final Differentiator differentiator;

    public MapEntryDiff(Map.Entry entry1, Map.Entry entry2, Diff keyDiff, Diff valueDiff, Differentiator differentiator) {
        this.entry1 = entry1;
        this.entry2 = entry2;
        this.keyDiff = keyDiff;
        this.valueDiff = valueDiff;
        this.differentiator = differentiator;
    }

    public Object getObject1() {
        return this.entry1;
    }

    public Object getObject2() {
        return this.entry2;
    }

    public boolean identical() {
        return !this.different();
    }

    public boolean different() {
        return this.keyDiff.different() || this.valueDiff.different();
    }

    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    public String getDescription() {
        if (this.identical()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)sw, "    ");
        this.appendHeader(pw);
        pw.indent();
        this.appendDescription(pw);
        pw.undent();
        return ((Object)sw).toString();
    }

    protected void appendHeader(IndentingPrintWriter pw) {
        pw.print("Map Entries are different:");
        pw.println();
        pw.print("entry 1: ");
        pw.print(this.entry1);
        pw.println();
        pw.print("entry 2: ");
        pw.print(this.entry2);
        pw.println();
    }

    public void appendDescription(IndentingPrintWriter pw) {
        if (this.keyDiff.different()) {
            pw.print("The entries' keys are different");
            pw.println();
            pw.indent();
            this.keyDiff.appendDescription(pw);
            pw.undent();
        }
        if (this.valueDiff.different()) {
            pw.print("The entries' values are different");
            pw.println();
            pw.indent();
            this.valueDiff.appendDescription(pw);
            pw.undent();
        }
    }

    public Map.Entry getEntry1() {
        return this.entry1;
    }

    public Map.Entry getEntry2() {
        return this.entry2;
    }

    public Diff getKeyDiff() {
        return this.keyDiff;
    }

    public Diff getValueDiff() {
        return this.valueDiff;
    }

    public String toString() {
        return this.identical() ? "<no difference>" : this.getDescription();
    }
}

