/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CollectionChangeEvent
extends EventObject {
    private String collectionName;
    private Collection items;
    private static final long serialVersionUID = 1L;

    public CollectionChangeEvent(Object source) {
        super(source);
    }

    public CollectionChangeEvent(Object source, String collectionName) {
        this(source);
        this.collectionName = collectionName;
    }

    public CollectionChangeEvent(Object source, String collectionName, Collection items) {
        super(source);
        this.collectionName = collectionName;
        this.items = items;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Iterator items() {
        if (this.items == null) {
            return NullIterator.instance();
        }
        return new ReadOnlyIterator(this.items);
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public CollectionChangeEvent cloneWithSource(Object newSource) {
        return new CollectionChangeEvent(newSource, this.collectionName, this.items);
    }

    public CollectionChangeEvent cloneWithSource(Object newSource, String newCollectionName) {
        return new CollectionChangeEvent(newSource, newCollectionName, this.items);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.collectionName);
    }
}

