/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResultSetIterator
implements Iterator {
    private final ResultSet resultSet;
    private final Adapter adapter;
    private Object next;
    private static final Object END = new Object();

    public ResultSetIterator(ResultSet resultSet, Adapter adapter) {
        this.resultSet = resultSet;
        this.adapter = adapter;
        this.next = this.buildNext();
    }

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, Adapter.DEFAULT_INSTANCE);
    }

    private Object buildNext() {
        try {
            if (this.resultSet.next()) {
                return this.buildNext(this.resultSet);
            }
            this.resultSet.close();
            return END;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object buildNext(ResultSet rs) throws SQLException {
        return this.adapter.buildNext(rs);
    }

    public boolean hasNext() {
        return this.next != END;
    }

    public Object next() {
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        Object temp = this.next;
        this.next = this.buildNext();
        return temp;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static interface Adapter {
        public static final Adapter DEFAULT_INSTANCE = new Adapter(){

            public Object buildNext(ResultSet rs) throws SQLException {
                return rs.getObject(1);
            }
        };

        public Object buildNext(ResultSet var1) throws SQLException;
    }
}

