/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringMatcher;

public class SimpleStringMatcher
implements StringMatcher,
Filter,
Serializable {
    private StringConverter stringConverter;
    private String patternString;
    private boolean ignoresCase;
    private Pattern pattern;
    public static final char[] REG_EX_META_CHARS = new char[]{'(', '[', '{', '\\', '^', '$', '|', ')', '?', '*', '+', '.'};
    private static final long serialVersionUID = 1L;

    public SimpleStringMatcher() {
        this("*");
    }

    public SimpleStringMatcher(String patternString) {
        this(patternString, true);
    }

    public SimpleStringMatcher(String patternString, boolean ignoresCase) {
        this.patternString = patternString;
        this.ignoresCase = ignoresCase;
        this.initialize();
    }

    protected void initialize() {
        this.stringConverter = StringConverter.DEFAULT_INSTANCE;
        this.rebuildPattern();
    }

    protected synchronized void rebuildPattern() {
        this.pattern = this.buildPattern();
    }

    protected Pattern buildPattern() {
        int patternFlags = 0;
        if (this.ignoresCase) {
            patternFlags = 66;
        }
        return Pattern.compile(this.convertToRegEx(this.patternString), patternFlags);
    }

    public synchronized void setPatternString(String patternString) {
        this.patternString = patternString;
        this.rebuildPattern();
    }

    public synchronized boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    public synchronized boolean accept(Object o) {
        return this.matches(this.stringConverter.convertToString(o));
    }

    public synchronized StringConverter getStringConverter() {
        return this.stringConverter;
    }

    public synchronized void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }

    public synchronized String getPatternString() {
        return this.patternString;
    }

    public synchronized boolean ignoresCase() {
        return this.ignoresCase;
    }

    public synchronized void setIgnoresCase(boolean ignoresCase) {
        this.ignoresCase = ignoresCase;
        this.rebuildPattern();
    }

    public synchronized Pattern getPattern() {
        return this.pattern;
    }

    public synchronized String regularExpression() {
        return this.convertToRegEx(this.patternString);
    }

    protected String convertToRegEx(String string) {
        StringBuffer sb = new StringBuffer(string.length() + 10);
        this.convertToRegExOn(this.prefix(), sb);
        this.convertToRegExOn(string, sb);
        this.convertToRegExOn(this.suffix(), sb);
        return sb.toString();
    }

    protected String prefix() {
        return "";
    }

    protected String suffix() {
        return "*";
    }

    protected void convertToRegExOn(String string, StringBuffer sb) {
        for (char c : string.toCharArray()) {
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append('.');
                continue;
            }
            if (CollectionTools.contains(REG_EX_META_CHARS, c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
    }
}

