/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.HashPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashPartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<String> connectionPools;

    public HashPartitioningMetadata() {
        super("<hash-partitioning>");
    }

    public HashPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.connectionPools = new ArrayList<String>();
        this.connectionPools.addAll(Arrays.asList((Object[])annotation.getAttributeArray("connectionPools")));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof HashPartitioningMetadata) {
            HashPartitioningMetadata policy = (HashPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.connectionPools, policy.getConnectionPools());
        }
        return false;
    }

    public List<String> getConnectionPools() {
        return this.connectionPools;
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        HashPartitioningPolicy policy = new HashPartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        policy.setConnectionPools(this.getConnectionPools());
        return policy;
    }

    public void setConnectionPools(List<String> connectionPools) {
        this.connectionPools = connectionPools;
    }
}

